/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;

public class QuotaConfigs {
    public static final String PRODUCER_BYTE_RATE_OVERRIDE_CONFIG = "producer_byte_rate";
    public static final String CONSUMER_BYTE_RATE_OVERRIDE_CONFIG = "consumer_byte_rate";
    public static final String REQUEST_PERCENTAGE_OVERRIDE_CONFIG = "request_percentage";
    public static final String CONTROLLER_MUTATION_RATE_OVERRIDE_CONFIG = "controller_mutation_rate";
    public static final String IP_CONNECTION_RATE_OVERRIDE_CONFIG = "connection_creation_rate";
    public static final String TENANT_CONNECTION_RATE_OVERRIDE_CONFIG = "connection_creation_rate";
    public static final String PRODUCER_BYTE_RATE_DOC = "A rate representing the upper bound (bytes/sec) for producer traffic.";
    public static final String CONSUMER_BYTE_RATE_DOC = "A rate representing the upper bound (bytes/sec) for consumer traffic.";
    public static final String REQUEST_PERCENTAGE_DOC = "A percentage representing the upper bound of time spent for processing requests.";
    public static final String CONTROLLER_MUTATION_RATE_DOC = "The rate at which mutations are accepted for the create topics request, the create partitions request and the delete topics request. The rate is accumulated by the number of partitions created or deleted.";
    public static final String IP_CONNECTION_RATE_DOC = "A double representing the upper bound of connections accepted for the specified IP.";
    public static final String TENANT_CONNECTION_RATE_DOC = "A double representing the upper bound of connections accepted for the specified tenant.";
    public static final double IP_CONNECTION_RATE_DEFAULT = Double.MAX_VALUE;
    public static final double TENANT_CONNECTION_RATE_DEFAULT = Double.MAX_VALUE;
    private static final Set<String> USER_AND_CLIENT_QUOTA_NAMES = new HashSet<String>(Arrays.asList("producer_byte_rate", "consumer_byte_rate", "request_percentage", "controller_mutation_rate"));

    private static void buildUserClientQuotaConfigDef(ConfigDef configDef) {
        configDef.define(PRODUCER_BYTE_RATE_OVERRIDE_CONFIG, ConfigDef.Type.LONG, Long.MAX_VALUE, ConfigDef.Importance.MEDIUM, PRODUCER_BYTE_RATE_DOC);
        configDef.define(CONSUMER_BYTE_RATE_OVERRIDE_CONFIG, ConfigDef.Type.LONG, Long.MAX_VALUE, ConfigDef.Importance.MEDIUM, CONSUMER_BYTE_RATE_DOC);
        configDef.define(REQUEST_PERCENTAGE_OVERRIDE_CONFIG, ConfigDef.Type.DOUBLE, Integer.valueOf(Integer.MAX_VALUE).doubleValue(), ConfigDef.Importance.MEDIUM, REQUEST_PERCENTAGE_DOC);
        configDef.define(CONTROLLER_MUTATION_RATE_OVERRIDE_CONFIG, ConfigDef.Type.DOUBLE, Integer.valueOf(Integer.MAX_VALUE).doubleValue(), ConfigDef.Importance.MEDIUM, CONTROLLER_MUTATION_RATE_DOC);
    }

    public static boolean isClientOrUserConfig(String name) {
        return USER_AND_CLIENT_QUOTA_NAMES.contains(name);
    }

    public static ConfigDef userAndClientQuotaConfigs() {
        ConfigDef configDef = new ConfigDef();
        QuotaConfigs.buildUserClientQuotaConfigDef(configDef);
        return configDef;
    }

    public static ConfigDef scramMechanismsPlusUserAndClientQuotaConfigs() {
        ConfigDef configDef = new ConfigDef();
        ScramMechanism.mechanismNames().forEach(mechanismName -> configDef.define((String)mechanismName, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "User credentials for SCRAM mechanism " + mechanismName));
        QuotaConfigs.buildUserClientQuotaConfigDef(configDef);
        return configDef;
    }

    public static ConfigDef ipConfigs() {
        ConfigDef configDef = new ConfigDef();
        configDef.define("connection_creation_rate", ConfigDef.Type.DOUBLE, Double.MAX_VALUE, ConfigDef.Range.atLeast(0.0), ConfigDef.Importance.MEDIUM, IP_CONNECTION_RATE_DOC);
        return configDef;
    }

    public static ConfigDef tenantConfigs() {
        ConfigDef configDef = new ConfigDef();
        configDef.define("connection_creation_rate", ConfigDef.Type.DOUBLE, Double.MAX_VALUE, ConfigDef.Range.atLeast(0.0), ConfigDef.Importance.MEDIUM, TENANT_CONNECTION_RATE_DOC);
        return configDef;
    }
}

