/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.AssignmentChangeApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.CommitApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ListOffsetsApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.NewTopicsMetadataUpdateRequestEvent;
import org.apache.kafka.clients.consumer.internals.events.NoopApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.NoopBackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.OffsetFetchApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.PollApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.TopicMetadataApplicationEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class ApplicationEventProcessor {
    private final BlockingQueue<BackgroundEvent> backgroundEventQueue;
    private final ConsumerMetadata metadata;
    private final RequestManagers requestManagers;

    public ApplicationEventProcessor(BlockingQueue<BackgroundEvent> backgroundEventQueue, RequestManagers requestManagers, ConsumerMetadata metadata) {
        this.backgroundEventQueue = backgroundEventQueue;
        this.requestManagers = requestManagers;
        this.metadata = metadata;
    }

    public boolean process(ApplicationEvent event) {
        Objects.requireNonNull(event);
        switch (event.type()) {
            case NOOP: {
                return this.process((NoopApplicationEvent)event);
            }
            case COMMIT: {
                return this.process((CommitApplicationEvent)event);
            }
            case POLL: {
                return this.process((PollApplicationEvent)event);
            }
            case FETCH_COMMITTED_OFFSET: {
                return this.process((OffsetFetchApplicationEvent)event);
            }
            case METADATA_UPDATE: {
                return this.process((NewTopicsMetadataUpdateRequestEvent)event);
            }
            case ASSIGNMENT_CHANGE: {
                return this.process((AssignmentChangeApplicationEvent)event);
            }
            case TOPIC_METADATA: {
                return this.process((TopicMetadataApplicationEvent)event);
            }
            case LIST_OFFSETS: {
                return this.process((ListOffsetsApplicationEvent)event);
            }
            case RESET_POSITIONS: {
                return this.processResetPositionsEvent();
            }
            case VALIDATE_POSITIONS: {
                return this.processValidatePositionsEvent();
            }
        }
        return false;
    }

    private boolean process(NoopApplicationEvent event) {
        return this.backgroundEventQueue.add(new NoopBackgroundEvent(event.message()));
    }

    private boolean process(PollApplicationEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            return true;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        manager.updateAutoCommitTimer(event.pollTimeMs());
        return true;
    }

    private boolean process(CommitApplicationEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            KafkaException exception = new KafkaException("Unable to commit offset. Most likely because the group.id wasn't set");
            event.future().completeExceptionally(exception);
            return false;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        event.chain(manager.addOffsetCommitRequest(event.offsets()));
        return true;
    }

    private boolean process(OffsetFetchApplicationEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            event.future().completeExceptionally(new KafkaException("Unable to fetch committed offset because the CommittedRequestManager is not available. Check if group.id was set correctly"));
            return false;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        event.chain(manager.addOffsetFetchRequest(event.partitions()));
        return true;
    }

    private boolean process(NewTopicsMetadataUpdateRequestEvent event) {
        this.metadata.requestUpdateForNewTopics();
        return true;
    }

    private boolean process(AssignmentChangeApplicationEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            return false;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        manager.updateAutoCommitTimer(event.currentTimeMs());
        manager.maybeAutoCommit(event.offsets());
        return true;
    }

    private boolean process(ListOffsetsApplicationEvent event) {
        CompletableFuture<Map<TopicPartition, OffsetAndTimestamp>> future = this.requestManagers.offsetsRequestManager.fetchOffsets(event.timestampsToSearch(), event.requireTimestamps());
        event.chain(future);
        return true;
    }

    private boolean processResetPositionsEvent() {
        this.requestManagers.offsetsRequestManager.resetPositionsIfNeeded();
        return true;
    }

    private boolean processValidatePositionsEvent() {
        this.requestManagers.offsetsRequestManager.validatePositionsIfNeeded();
        return true;
    }

    private boolean process(TopicMetadataApplicationEvent event) {
        CompletableFuture<Map<String, List<PartitionInfo>>> future = this.requestManagers.topicMetadataRequestManager.requestTopicMetadata(Optional.of(event.topic()));
        event.chain(future);
        return true;
    }
}

