/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

public class ExclusionRequestUtils {
    public static final int MAX_REASON_STRING_LENGTH = 1024;

    public static void validateReason(String reason) {
        ExclusionRequestUtils.validate(reason, true);
    }

    public static void validateNonEmptyReason(String reason) {
        ExclusionRequestUtils.validate(reason, false);
    }

    private static void validate(String reason, boolean allowEmpty) {
        if (reason.length() > 1024) {
            throw new IllegalArgumentException(String.format("The given reason '%s' cannot be more than %d characters. Instead, it was %d. Please choose another reason", reason, 1024, reason.length()));
        }
        if (reason.equals(".") || reason.equals("..")) {
            throw new IllegalArgumentException(String.format("A reason cannot be equal to '%s'. Please choose another reason", reason));
        }
        if (!allowEmpty && reason.length() == 0) {
            throw new IllegalArgumentException("An empty reason is not allowed.");
        }
        if (!ExclusionRequestUtils.containsValidPattern(reason)) {
            throw new IllegalArgumentException(String.format("The provided reason `%s` contains invalid characters. Valid characters are the ASCII alphanumerics, `.`, `_` and `-`. Please choose another reason", reason));
        }
    }

    private static boolean containsValidPattern(String reason) {
        for (int i = 0; i < reason.length(); ++i) {
            boolean validChar;
            char c = reason.charAt(i);
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '.' || c == '_' || c == '-' || c == ' ';
            if (validChar) continue;
            return false;
        }
        return true;
    }
}

