/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.security.authorizer.Scope;
import java.util.Objects;

public class TenantMetadata {
    public final String tenantName;
    public final String clusterId;
    public String organizationId;
    public String environmentId;
    public final String userResourceId;
    public final boolean isServiceAccount;
    public boolean isApiKeyAuthenticated;
    public boolean isHealthcheckTenant;
    private Scope scope;

    public TenantMetadata(String tenantName, String clusterId) {
        this(tenantName, clusterId, null, null, null, false, false, false);
    }

    TenantMetadata(String tenantName, String clusterId, String organizationId, String environmentId, String userResourceId, boolean isServiceAccount, boolean isApiKeyAuthenticated, boolean isHealthcheckTenant) {
        this.tenantName = TenantMetadata.requireNonEmpty(tenantName, "Tenant");
        this.clusterId = TenantMetadata.requireNonEmpty(clusterId, "ClusterId");
        this.organizationId = organizationId;
        this.environmentId = environmentId;
        this.userResourceId = userResourceId;
        this.isServiceAccount = isServiceAccount;
        this.isApiKeyAuthenticated = isApiKeyAuthenticated;
        this.isHealthcheckTenant = isHealthcheckTenant;
        this.scope = this.buildScope();
    }

    public String tenantPrefix() {
        return this.tenantName + "_";
    }

    private Scope buildScope() {
        if (this.organizationId != null && this.environmentId != null) {
            return new Scope.Builder(new String[0]).addPath("organization=" + this.organizationId).addPath("environment=" + this.environmentId).addPath("cloud-cluster=" + this.clusterId).withKafkaCluster(this.clusterId).build();
        }
        return Scope.kafkaClusterScope(this.clusterId);
    }

    public void updateOrgProperties(String organizationId, String environmentId) {
        this.organizationId = organizationId;
        this.environmentId = environmentId;
        this.scope = this.buildScope();
    }

    public Scope scope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantMetadata that = (TenantMetadata)o;
        return Objects.equals(this.tenantName, that.tenantName) && Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.userResourceId, that.userResourceId);
    }

    public int hashCode() {
        return Objects.hash(this.tenantName, this.clusterId, this.userResourceId);
    }

    public String toString() {
        return "TenantMetadata(tenantName='" + this.tenantName + "', clusterId='" + this.clusterId + "', organizationId='" + this.organizationId + "', environmentId='" + this.environmentId + "', userResourceId=" + this.userResourceId + ", isServiceAccount=" + this.isServiceAccount + ", isApiKeyAuthenticated=" + this.isApiKeyAuthenticated + ", isHealthcheckTenant=" + this.isHealthcheckTenant + ")";
    }

    private static String requireNonEmpty(String value, String argName) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(argName + " must not be empty or null");
        }
        return value;
    }

    public static class Builder {
        public final String tenantName;
        public final String clusterId;
        public String organizationId;
        public String environmentId;
        private final String userResourceId;
        public boolean isServiceAccount;
        public boolean isApiKeyAuthenticated;
        public boolean isHealthcheckTenant;

        public Builder(String clusterId, String userResourceId) {
            this.clusterId = clusterId;
            this.tenantName = clusterId;
            this.userResourceId = userResourceId;
        }

        public Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder serviceAccount(boolean isServiceAccount) {
            this.isServiceAccount = isServiceAccount;
            return this;
        }

        public Builder apiKeyAuthenticated(boolean isApiKeyAuthenticated) {
            this.isApiKeyAuthenticated = isApiKeyAuthenticated;
            return this;
        }

        public Builder healthcheckTenant(boolean isHealthcheckTenant) {
            this.isHealthcheckTenant = isHealthcheckTenant;
            return this;
        }

        public TenantMetadata build() {
            return new TenantMetadata(this.tenantName, this.clusterId, this.organizationId, this.environmentId, this.userResourceId, this.isServiceAccount, this.isApiKeyAuthenticated, this.isHealthcheckTenant);
        }
    }
}

