/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.http.server;

import io.confluent.kafka.http.server.KafkaHttpServer;
import io.confluent.kafka.http.server.KafkaHttpServerInjector;
import io.confluent.kafka.http.server.KafkaHttpServerLoadingException;
import io.confluent.kafka.http.server.KafkaHttpServerProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaHttpServerLoader {
    private static final Logger log = LoggerFactory.getLogger(KafkaHttpServerLoader.class);

    private KafkaHttpServerLoader() {
    }

    public static Optional<KafkaHttpServer> load(Map<String, Object> configuration, KafkaHttpServerInjector injector) {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(injector);
        HashSet<KafkaHttpServer> implementations = new HashSet<KafkaHttpServer>();
        for (KafkaHttpServerProvider provider : ServiceLoader.load(KafkaHttpServerProvider.class)) {
            Optional<KafkaHttpServer> implementation;
            try {
                implementation = provider.provide(configuration, injector);
            }
            catch (Throwable error) {
                throw new KafkaHttpServerLoadingException(String.format("Failed to load KafkaHttpServer implementation from provider %s. Skipping.", provider.getClass().getSimpleName()), error);
            }
            if (!implementation.isPresent()) {
                log.info("KafkaHttpServer implementation from provider {} is disabled. Skipping.", (Object)provider.getClass().getSimpleName());
                continue;
            }
            implementations.add(implementation.get());
        }
        if (implementations.isEmpty()) {
            log.info("No Kafka HTTP server implementation configured. Skipping.");
            return Optional.empty();
        }
        if (implementations.size() > 1) {
            throw new IllegalStateException(String.format("Multiple implementations found for KafkaHttpServer: %s.", implementations));
        }
        KafkaHttpServer implementation = (KafkaHttpServer)implementations.iterator().next();
        log.info("Loaded KafkaHttpServer implementation {}", implementation.getClass());
        return Optional.of(implementation);
    }
}

