/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class VoteResponse
extends AbstractResponse {
    private final VoteResponseData data;

    public VoteResponse(VoteResponseData data) {
        super(ApiKeys.VOTE);
        this.data = data;
    }

    public static VoteResponseData singletonResponse(Errors topLevelError, TopicPartition topicPartition, Errors partitionLevelError, int leaderEpoch, int leaderId, boolean voteGranted) {
        return new VoteResponseData().setErrorCode(topLevelError.code()).setTopics(Collections.singletonList(new VoteResponseData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(new VoteResponseData.PartitionData().setErrorCode(partitionLevelError.code()).setLeaderId(leaderId).setLeaderEpoch(leaderEpoch).setVoteGranted(voteGranted)))));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errors = new HashMap<Errors, Integer>();
        errors.put(Errors.forCode(this.data.errorCode()), 1);
        for (VoteResponseData.TopicData topicResponse : this.data.topics()) {
            for (VoteResponseData.PartitionData partitionResponse : topicResponse.partitions()) {
                this.updateErrorCounts(errors, Errors.forCode(partitionResponse.errorCode()));
            }
        }
        return errors;
    }

    @Override
    public VoteResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    public static VoteResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new VoteResponse(new VoteResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

