/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractControlResponse;

public class LeaderAndIsrResponse
extends AbstractControlResponse {
    private final LeaderAndIsrResponseData data;
    private short version;

    public LeaderAndIsrResponse(LeaderAndIsrResponseData data, short version) {
        super(ApiKeys.LEADER_AND_ISR);
        this.data = data;
        this.version = version;
    }

    public List<LeaderAndIsrResponseData.LeaderAndIsrTopicError> topics() {
        return this.data.topics();
    }

    @Override
    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        Errors error = this.error();
        if (error != Errors.NONE) {
            if (this.version < 5) {
                return Collections.singletonMap(error, this.data.partitionErrors().size() + 1);
            }
            return Collections.singletonMap(error, this.data.topics().stream().mapToInt(t -> t.partitionErrors().size()).sum() + 1);
        }
        Map<Errors, Integer> errors = this.version < 5 ? this.errorCounts(this.data.partitionErrors().stream().map(l -> Errors.forCode(l.errorCode()))) : this.errorCounts(this.data.topics().stream().flatMap(t -> t.partitionErrors().stream()).map(l -> Errors.forCode(l.errorCode())));
        this.updateErrorCounts(errors, Errors.NONE);
        return errors;
    }

    @Override
    public Map<TopicPartition, Errors> partitionErrors(Map<Uuid, String> topicNames) {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        if (this.version < 5) {
            this.data.partitionErrors().forEach(partition -> errors.put(new TopicPartition(partition.topicName(), partition.partitionIndex()), Errors.forCode(partition.errorCode())));
        } else {
            for (LeaderAndIsrResponseData.LeaderAndIsrTopicError topic : this.data.topics()) {
                String topicName = topicNames.get(topic.topicId());
                if (topicName == null) continue;
                topic.partitionErrors().forEach(partition -> errors.put(new TopicPartition(topicName, partition.partitionIndex()), Errors.forCode(partition.errorCode())));
            }
        }
        return errors;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    public static LeaderAndIsrResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new LeaderAndIsrResponse(new LeaderAndIsrResponseData(new ByteBufferAccessor(buffer), version, context), version);
    }

    @Override
    public LeaderAndIsrResponseData data() {
        return this.data;
    }

    @Override
    public String toString() {
        return this.data.toString();
    }
}

