/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.message.AlterMirrorsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterMirrorsResponse;

public class AlterMirrorsRequest
extends AbstractRequest {
    private final AlterMirrorsRequestData data;

    public AlterMirrorsRequest(AlterMirrorsRequestData data, short version) {
        super(ApiKeys.ALTER_MIRRORS, version);
        this.data = data;
    }

    public boolean validateOnly() {
        return this.data.validateOnly();
    }

    public int timeoutMs() {
        return this.data.timeoutMs();
    }

    public List<AlterMirrorsRequestData.MirrorOperation> mirrorOperations() {
        if (!this.data.mirrorOperations().isEmpty()) {
            return this.data.mirrorOperations();
        }
        return this.data.ops().stream().map(AlterMirrorsRequest::mirrorOperation).collect(Collectors.toList());
    }

    @Override
    public AlterMirrorsRequestData data() {
        return this.data;
    }

    @Override
    public AlterMirrorsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short errorCode = Errors.forException(e).code();
        String errorMessage = e.getMessage();
        AlterMirrorsResponseData responseData = new AlterMirrorsResponseData().setThrottleTimeMs(throttleTimeMs);
        List<AlterMirrorsResponseData.AlterMirrorResult> results = this.mirrorOperations().stream().map(op -> {
            AlterMirrorsResponseData.AlterMirrorResult result = new AlterMirrorsResponseData.AlterMirrorResult().setErrorCode(errorCode).setErrorMessage(errorMessage);
            if (this.version() >= 2) {
                result.setTopic(op.topic());
            }
            return result;
        }).collect(Collectors.toList());
        responseData.setResults(results);
        return new AlterMirrorsResponse(responseData);
    }

    public static AlterMirrorsRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AlterMirrorsRequest(new AlterMirrorsRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    private static List<AlterMirrorsRequestData.OpData> opDatas(List<AlterMirrorsRequestData.MirrorOperation> mirrorOps) {
        ArrayList<AlterMirrorsRequestData.OpData> opDatas = new ArrayList<AlterMirrorsRequestData.OpData>(mirrorOps.size());
        for (AlterMirrorsRequestData.MirrorOperation op : mirrorOps) {
            AlterMirrorsRequestData.OpData opData = new AlterMirrorsRequestData.OpData();
            AlterMirrorOp mirrorOp = AlterMirrorOp.forId(op.operationCode());
            if (mirrorOp == null) {
                throw new InvalidRequestException("Unsupported mirror operation code " + op.operationCode());
            }
            switch (mirrorOp) {
                case PROMOTE: {
                    opData.setStopTopicMirror(Collections.singletonList(new AlterMirrorsRequestData.StopTopicMirrorData().setTopic(op.topic()).setSynchronize(true)));
                    break;
                }
                case FAILOVER: {
                    opData.setStopTopicMirror(Collections.singletonList(new AlterMirrorsRequestData.StopTopicMirrorData().setTopic(op.topic()).setSynchronize(false)));
                    break;
                }
                case PAUSE: {
                    opData.setPauseTopicMirror(Collections.singletonList(new AlterMirrorsRequestData.PauseTopicMirrorData().setTopic(op.topic()).setEnable(true).setLinkLevel(false)));
                    break;
                }
                case RESUME: {
                    opData.setPauseTopicMirror(Collections.singletonList(new AlterMirrorsRequestData.PauseTopicMirrorData().setTopic(op.topic()).setEnable(false).setLinkLevel(false)));
                    break;
                }
                case PAUSE_LINK: {
                    opData.setPauseTopicMirror(Collections.singletonList(new AlterMirrorsRequestData.PauseTopicMirrorData().setTopic(op.topic()).setEnable(true).setLinkLevel(true)));
                    break;
                }
                case RESUME_LINK: {
                    opData.setPauseTopicMirror(Collections.singletonList(new AlterMirrorsRequestData.PauseTopicMirrorData().setTopic(op.topic()).setEnable(false).setLinkLevel(true)));
                    break;
                }
                case CLEAR: {
                    opData.setClearTopicMirror(Collections.singletonList(new AlterMirrorsRequestData.ClearTopicMirrorData().setTopic(op.topic())));
                    break;
                }
                default: {
                    throw new InvalidRequestException("Unsupported mirror operation " + (Object)((Object)mirrorOp));
                }
            }
            opDatas.add(opData);
        }
        return opDatas;
    }

    private static AlterMirrorsRequestData.MirrorOperation mirrorOperation(AlterMirrorsRequestData.OpData op) {
        if (!op.stopTopicMirror().isEmpty()) {
            AlterMirrorsRequestData.StopTopicMirrorData stop = op.stopTopicMirror().get(0);
            AlterMirrorOp mirrorOp = stop.synchronize() ? AlterMirrorOp.PROMOTE : AlterMirrorOp.FAILOVER;
            return new AlterMirrorsRequestData.MirrorOperation().setTopic(stop.topic()).setOperationCode(mirrorOp.id());
        }
        if (!op.pauseTopicMirror().isEmpty()) {
            AlterMirrorsRequestData.PauseTopicMirrorData pause = op.pauseTopicMirror().get(0);
            AlterMirrorOp mirrorOp = !pause.linkLevel() ? (pause.enable() ? AlterMirrorOp.PAUSE : AlterMirrorOp.RESUME) : (pause.enable() ? AlterMirrorOp.PAUSE_LINK : AlterMirrorOp.RESUME_LINK);
            return new AlterMirrorsRequestData.MirrorOperation().setTopic(pause.topic()).setOperationCode(mirrorOp.id());
        }
        if (!op.clearTopicMirror().isEmpty()) {
            AlterMirrorsRequestData.ClearTopicMirrorData stop = op.clearTopicMirror().get(0);
            return new AlterMirrorsRequestData.MirrorOperation().setTopic(stop.topic()).setOperationCode(AlterMirrorOp.CLEAR.id());
        }
        throw new InvalidRequestException("Unexpected alter mirrors op type");
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterMirrorsRequest> {
        private final List<AlterMirrorsRequestData.MirrorOperation> ops;
        private final boolean validateOnly;
        private final int timeoutMs;

        public Builder(List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly, int timeoutMs) {
            super(ApiKeys.ALTER_MIRRORS);
            this.ops = ops;
            this.validateOnly = validateOnly;
            this.timeoutMs = timeoutMs;
        }

        @Override
        public AlterMirrorsRequest build(short version) {
            AlterMirrorsRequestData data = new AlterMirrorsRequestData().setValidateOnly(this.validateOnly).setTimeoutMs(this.timeoutMs);
            if (version >= 2) {
                data.setMirrorOperations(this.ops);
            } else {
                data.setOps(AlterMirrorsRequest.opDatas(this.ops));
            }
            return new AlterMirrorsRequest(data, version);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(type=AlterMirrorsRequest").append(", ops=").append(this.ops).append(", validateOnly=").append(this.validateOnly).append(", timeoutMs=").append(this.timeoutMs).append(")");
            return builder.toString();
        }
    }
}

