/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MultiRecordsSend;
import org.apache.kafka.common.record.UnalignedMemoryRecords;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.utils.ByteUtils;

public class SendBuilder
implements Writable {
    private final ByteBuffer buffer;
    private final Queue<Send> sends = new ArrayDeque<Send>(1);
    private long sizeOfSends = 0L;
    private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private long sizeOfBuffers = 0L;

    SendBuilder(int size) {
        this.buffer = ByteBuffer.allocate(size);
        this.buffer.mark();
    }

    @Override
    public void writeByte(byte val) {
        this.buffer.put(val);
    }

    @Override
    public void writeShort(short val) {
        this.buffer.putShort(val);
    }

    @Override
    public void writeInt(int val) {
        this.buffer.putInt(val);
    }

    @Override
    public void writeLong(long val) {
        this.buffer.putLong(val);
    }

    @Override
    public void writeDouble(double val) {
        this.buffer.putDouble(val);
    }

    @Override
    public void writeByteArray(byte[] arr) {
        this.buffer.put(arr);
    }

    @Override
    public void writeUnsignedVarint(int i) {
        ByteUtils.writeUnsignedVarint(i, this.buffer);
    }

    @Override
    public void writeByteBuffer(ByteBuffer buf) {
        this.flushPendingBuffer();
        this.addBuffer(buf.duplicate());
    }

    @Override
    public void writeVarint(int i) {
        ByteUtils.writeVarint(i, this.buffer);
    }

    @Override
    public void writeVarlong(long i) {
        ByteUtils.writeVarlong(i, this.buffer);
    }

    private void addBuffer(ByteBuffer buffer) {
        this.buffers.add(buffer);
        this.sizeOfBuffers += (long)buffer.remaining();
    }

    private void addSend(Send send) {
        this.sends.add(send);
        this.sizeOfSends += send.size();
    }

    private void clearBuffers() {
        this.buffers.clear();
        this.sizeOfBuffers = 0L;
    }

    @Override
    public void writeRecords(BaseRecords records) {
        if (records.getClass().equals(MemoryRecords.class)) {
            this.flushPendingBuffer();
            this.addBuffer(((MemoryRecords)records).buffer());
        } else if (records instanceof UnalignedMemoryRecords) {
            this.flushPendingBuffer();
            this.addBuffer(((UnalignedMemoryRecords)records).buffer());
        } else {
            this.flushPendingSend();
            this.addSend(records.toSend());
        }
    }

    private void flushPendingSend() {
        this.flushPendingBuffer();
        if (!this.buffers.isEmpty()) {
            ByteBuffer[] byteBufferArray = this.buffers.toArray(new ByteBuffer[0]);
            this.addSend(new ByteBufferSend(byteBufferArray, this.sizeOfBuffers));
            this.clearBuffers();
        }
    }

    private void flushPendingBuffer() {
        int latestPosition = this.buffer.position();
        this.buffer.reset();
        if (latestPosition > this.buffer.position()) {
            this.buffer.limit(latestPosition);
            this.addBuffer(this.buffer.slice());
            this.buffer.position(latestPosition);
            this.buffer.limit(this.buffer.capacity());
            this.buffer.mark();
        }
    }

    public Send build() {
        this.flushPendingSend();
        if (this.sends.size() == 1) {
            return this.sends.poll();
        }
        return new MultiRecordsSend(this.sends, this.sizeOfSends);
    }

    public static Send buildRequestSend(RequestHeader header, Message apiRequest) {
        return SendBuilder.buildSend(header.data(), header.headerVersion(), apiRequest, header.apiVersion(), MessageContext.IDENTITY);
    }

    public static Send buildRequestSend(RequestHeader header, Message apiRequest, MessageContext context) {
        return SendBuilder.buildSend(header.data(), header.headerVersion(), apiRequest, header.apiVersion(), context);
    }

    public static Send buildResponseSend(ResponseHeader header, Message apiResponse, short apiVersion) {
        return SendBuilder.buildSend(header.data(), header.headerVersion(), apiResponse, apiVersion, MessageContext.IDENTITY);
    }

    public static Send buildResponseSend(ResponseHeader header, Message apiResponse, short apiVersion, MessageContext context) {
        return SendBuilder.buildSend(header.data(), header.headerVersion(), apiResponse, apiVersion, context);
    }

    private static Send buildSend(Message header, short headerVersion, Message apiMessage, short apiVersion, MessageContext context) {
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        MessageSizeAccumulator messageSize = new MessageSizeAccumulator();
        header.addSize(messageSize, serializationCache, headerVersion, context);
        apiMessage.addSize(messageSize, serializationCache, apiVersion, context);
        SendBuilder builder = new SendBuilder(messageSize.sizeExcludingZeroCopy() + 4);
        builder.writeInt(messageSize.totalSize());
        header.write(builder, serializationCache, headerVersion, context);
        apiMessage.write(builder, serializationCache, apiVersion, context);
        return builder.build();
    }
}

