/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeMirrorsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<TopicData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topics", CompactArrayOf.nullable(TopicData.SCHEMA_0), "The mirror topic descriptions."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeMirrorsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeMirrorsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.topics = new ArrayList<TopicData>(0);
    }

    @Override
    public short apiKey() {
        return 10009;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.topics = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<TopicData> newCollection = new ArrayList<TopicData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicData(_readable, _version, _context));
            }
            this.topics = newCollection;
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.topics == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                TopicData topicsElement = (TopicData)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.topics == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
            for (TopicData topicsElement : this.topics) {
                topicsElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeMirrorsResponseData)) {
            return false;
        }
        DescribeMirrorsResponseData other = (DescribeMirrorsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public DescribeMirrorsResponseData duplicate() {
        DescribeMirrorsResponseData _duplicate = new DescribeMirrorsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        if (this.topics == null) {
            _duplicate.topics = null;
        } else {
            ArrayList<TopicData> newTopics = new ArrayList<TopicData>(this.topics.size());
            for (TopicData _element : this.topics) {
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
        }
        return _duplicate;
    }

    public String toString() {
        return "DescribeMirrorsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", topics=" + (this.topics == null ? "null" : MessageUtil.deepToString(this.topics.iterator())) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<TopicData> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeMirrorsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeMirrorsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeMirrorsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeMirrorsResponseData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }

    public static class TopicData
    implements Message {
        short errorCode;
        String errorMessage;
        String topic;
        String linkName;
        String linkId;
        String mirrorTopic;
        int numPartitions;
        String state;
        long stateTimeMs;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("link_name", Type.COMPACT_STRING, "The name of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("link_id", Type.COMPACT_STRING, "The ID of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("mirror_topic", Type.COMPACT_STRING, "The name of the topic over the cluster link that's mirrored, otherwise empty if error."), new Field("num_partitions", Type.INT32, "The number of partitions for the mirror topic, otherwise `0` if error."), new Field("state", Type.COMPACT_STRING, "The state of the topic mirroring, otherwise empty if error."), new Field("state_time_ms", Type.INT64, "The time, in milliseconds since epoch, when the mirror transition to the latest topic state, or `-1` if error."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicData() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.topic = "";
            this.linkName = "";
            this.linkId = "";
            this.mirrorTopic = "";
            this.numPartitions = 0;
            this.state = "";
            this.stateTimeMs = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkName had invalid length " + length);
            }
            this.linkName = _context.read(EntityType.LINK_NAME, _readable.readString(length));
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkId had invalid length " + length);
            }
            this.linkId = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field mirrorTopic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field mirrorTopic had invalid length " + length);
            }
            this.mirrorTopic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.numPartitions = _readable.readInt();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field state was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field state had invalid length " + length);
            }
            this.state = _readable.readString(length);
            this.stateTimeMs = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.linkName);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.linkId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.mirrorTopic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.numPartitions);
            _stringBytes = _cache.getSerializedValue(this.state);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeLong(this.stateTimeMs);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = _context.write(EntityType.LINK_NAME, this.linkName).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.linkName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.linkId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.linkId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = _context.write(EntityType.TOPIC_NAME, this.mirrorTopic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'mirrorTopic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.mirrorTopic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            _stringBytes = this.state.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'state' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.state, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.linkName == null ? other.linkName != null : !this.linkName.equals(other.linkName)) {
                return false;
            }
            if (this.linkId == null ? other.linkId != null : !this.linkId.equals(other.linkId)) {
                return false;
            }
            if (this.mirrorTopic == null ? other.mirrorTopic != null : !this.mirrorTopic.equals(other.mirrorTopic)) {
                return false;
            }
            if (this.numPartitions != other.numPartitions) {
                return false;
            }
            if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
                return false;
            }
            if (this.stateTimeMs != other.stateTimeMs) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.linkName == null ? 0 : this.linkName.hashCode());
            hashCode = 31 * hashCode + (this.linkId == null ? 0 : this.linkId.hashCode());
            hashCode = 31 * hashCode + (this.mirrorTopic == null ? 0 : this.mirrorTopic.hashCode());
            hashCode = 31 * hashCode + this.numPartitions;
            hashCode = 31 * hashCode + (this.state == null ? 0 : this.state.hashCode());
            hashCode = 31 * hashCode + ((int)(this.stateTimeMs >> 32) ^ (int)this.stateTimeMs);
            return hashCode;
        }

        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.topic = this.topic;
            _duplicate.linkName = this.linkName;
            _duplicate.linkId = this.linkId;
            _duplicate.mirrorTopic = this.mirrorTopic;
            _duplicate.numPartitions = this.numPartitions;
            _duplicate.state = this.state;
            _duplicate.stateTimeMs = this.stateTimeMs;
            return _duplicate;
        }

        public String toString() {
            return "TopicData(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", linkName=" + (this.linkName == null ? "null" : "'" + this.linkName.toString() + "'") + ", linkId=" + (this.linkId == null ? "null" : "'" + this.linkId.toString() + "'") + ", mirrorTopic=" + (this.mirrorTopic == null ? "null" : "'" + this.mirrorTopic.toString() + "'") + ", numPartitions=" + this.numPartitions + ", state=" + (this.state == null ? "null" : "'" + this.state.toString() + "'") + ", stateTimeMs=" + this.stateTimeMs + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public String topic() {
            return this.topic;
        }

        public String linkName() {
            return this.linkName;
        }

        public String linkId() {
            return this.linkId;
        }

        public String mirrorTopic() {
            return this.mirrorTopic;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public String state() {
            return this.state;
        }

        public long stateTimeMs() {
            return this.stateTimeMs;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public TopicData setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public TopicData setTopic(String v) {
            this.topic = v;
            return this;
        }

        public TopicData setLinkName(String v) {
            this.linkName = v;
            return this;
        }

        public TopicData setLinkId(String v) {
            this.linkId = v;
            return this;
        }

        public TopicData setMirrorTopic(String v) {
            this.mirrorTopic = v;
            return this;
        }

        public TopicData setNumPartitions(int v) {
            this.numPartitions = v;
            return this;
        }

        public TopicData setState(String v) {
            this.state = v;
            return this;
        }

        public TopicData setStateTimeMs(long v) {
            this.stateTimeMs = v;
            return this;
        }
    }
}

