/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterMirrorsRequestData
implements ApiMessage {
    List<OpData> ops;
    List<MirrorOperation> mirrorOperations;
    boolean validateOnly;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("ops", new CompactArrayOf(OpData.SCHEMA_0), "The mirror control operations."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("ops", new CompactArrayOf(OpData.SCHEMA_1), "The mirror control operations."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_2 = new Schema(new Field("mirror_operations", new CompactArrayOf(MirrorOperation.SCHEMA_2), "The mirror control operations."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public AlterMirrorsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterMirrorsRequestData() {
        this.ops = new ArrayList<OpData>(0);
        this.mirrorOperations = new ArrayList<MirrorOperation>(0);
        this.validateOnly = false;
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 10006;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ArrayList<OpData> newCollection;
        int arrayLength;
        if (_version <= 1) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field ops was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<OpData>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new OpData(_readable, _version, _context));
            }
            this.ops = newCollection;
        } else {
            this.ops = new ArrayList<OpData>(0);
        }
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field mirrorOperations was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((OpData)((Object)new MirrorOperation(_readable, _version, _context)));
            }
            this.mirrorOperations = newCollection;
        } else {
            this.mirrorOperations = new ArrayList<MirrorOperation>(0);
        }
        this.validateOnly = _readable.readByte() != 0;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version <= 1) {
            _writable.writeUnsignedVarint(this.ops.size() + 1);
            for (OpData opsElement : this.ops) {
                opsElement.write(_writable, _cache, _version, _context);
            }
        } else if (!this.ops.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ops at version " + _version);
        }
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.mirrorOperations.size() + 1);
            for (MirrorOperation mirrorOperationsElement : this.mirrorOperations) {
                mirrorOperationsElement.write(_writable, _cache, _version, _context);
            }
        } else if (!this.mirrorOperations.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default mirrorOperations at version " + _version);
        }
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version <= 1) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.ops.size() + 1));
            for (OpData opsElement : this.ops) {
                opsElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.mirrorOperations.size() + 1));
            for (MirrorOperation mirrorOperationsElement : this.mirrorOperations) {
                mirrorOperationsElement.addSize(_size, _cache, _version, _context);
            }
        }
        _size.addBytes(1);
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterMirrorsRequestData)) {
            return false;
        }
        AlterMirrorsRequestData other = (AlterMirrorsRequestData)obj;
        if (this.ops == null ? other.ops != null : !this.ops.equals(other.ops)) {
            return false;
        }
        if (this.mirrorOperations == null ? other.mirrorOperations != null : !this.mirrorOperations.equals(other.mirrorOperations)) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.ops == null ? 0 : this.ops.hashCode());
        hashCode = 31 * hashCode + (this.mirrorOperations == null ? 0 : this.mirrorOperations.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public AlterMirrorsRequestData duplicate() {
        AlterMirrorsRequestData _duplicate = new AlterMirrorsRequestData();
        ArrayList<OpData> newOps = new ArrayList<OpData>(this.ops.size());
        for (OpData _element : this.ops) {
            newOps.add(_element.duplicate());
        }
        _duplicate.ops = newOps;
        ArrayList<MirrorOperation> newMirrorOperations = new ArrayList<MirrorOperation>(this.mirrorOperations.size());
        for (MirrorOperation _element : this.mirrorOperations) {
            newMirrorOperations.add(_element.duplicate());
        }
        _duplicate.mirrorOperations = newMirrorOperations;
        _duplicate.validateOnly = this.validateOnly;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "AlterMirrorsRequestData(ops=" + MessageUtil.deepToString(this.ops.iterator()) + ", mirrorOperations=" + MessageUtil.deepToString(this.mirrorOperations.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<OpData> ops() {
        return this.ops;
    }

    public List<MirrorOperation> mirrorOperations() {
        return this.mirrorOperations;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterMirrorsRequestData setOps(List<OpData> v) {
        this.ops = v;
        return this;
    }

    public AlterMirrorsRequestData setMirrorOperations(List<MirrorOperation> v) {
        this.mirrorOperations = v;
        return this;
    }

    public AlterMirrorsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    public AlterMirrorsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public static class MirrorOperation
    implements Message {
        String topic;
        byte operationCode;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("operation_code", Type.INT8, "The operation to perform on the mirror."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public MirrorOperation(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public MirrorOperation() {
            this.topic = "";
            this.operationCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MirrorOperation");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.operationCode = _readable.readByte();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MirrorOperation");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.operationCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MirrorOperation");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MirrorOperation)) {
                return false;
            }
            MirrorOperation other = (MirrorOperation)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.operationCode != other.operationCode) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + this.operationCode;
            return hashCode;
        }

        @Override
        public MirrorOperation duplicate() {
            MirrorOperation _duplicate = new MirrorOperation();
            _duplicate.topic = this.topic;
            _duplicate.operationCode = this.operationCode;
            return _duplicate;
        }

        public String toString() {
            return "MirrorOperation(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", operationCode=" + this.operationCode + ")";
        }

        public String topic() {
            return this.topic;
        }

        public byte operationCode() {
            return this.operationCode;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MirrorOperation setTopic(String v) {
            this.topic = v;
            return this;
        }

        public MirrorOperation setOperationCode(byte v) {
            this.operationCode = v;
            return this;
        }
    }

    public static class PauseTopicMirrorData
    implements Message {
        String topic;
        boolean enable;
        boolean linkLevel;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("enable", Type.BOOLEAN, "If true, pauses the topic's mirroring, otherwise removes the paused state."), new Field("link_level", Type.BOOLEAN, "Whether the pausing is being applied at the link level (internal), otherwise topic level (client)."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public PauseTopicMirrorData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PauseTopicMirrorData() {
            this.topic = "";
            this.enable = false;
            this.linkLevel = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.enable = _readable.readByte() != 0;
            this.linkLevel = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PauseTopicMirrorData");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.enable ? (byte)1 : 0);
            _writable.writeByte(this.linkLevel ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(1);
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PauseTopicMirrorData)) {
                return false;
            }
            PauseTopicMirrorData other = (PauseTopicMirrorData)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.enable != other.enable) {
                return false;
            }
            if (this.linkLevel != other.linkLevel) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.enable ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.linkLevel ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public PauseTopicMirrorData duplicate() {
            PauseTopicMirrorData _duplicate = new PauseTopicMirrorData();
            _duplicate.topic = this.topic;
            _duplicate.enable = this.enable;
            _duplicate.linkLevel = this.linkLevel;
            return _duplicate;
        }

        public String toString() {
            return "PauseTopicMirrorData(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", enable=" + (this.enable ? "true" : "false") + ", linkLevel=" + (this.linkLevel ? "true" : "false") + ")";
        }

        public String topic() {
            return this.topic;
        }

        public boolean enable() {
            return this.enable;
        }

        public boolean linkLevel() {
            return this.linkLevel;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PauseTopicMirrorData setTopic(String v) {
            this.topic = v;
            return this;
        }

        public PauseTopicMirrorData setEnable(boolean v) {
            this.enable = v;
            return this;
        }

        public PauseTopicMirrorData setLinkLevel(boolean v) {
            this.linkLevel = v;
            return this;
        }
    }

    public static class ClearTopicMirrorData
    implements Message {
        String topic;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public ClearTopicMirrorData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ClearTopicMirrorData() {
            this.topic = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClearTopicMirrorData)) {
                return false;
            }
            ClearTopicMirrorData other = (ClearTopicMirrorData)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            return hashCode;
        }

        @Override
        public ClearTopicMirrorData duplicate() {
            ClearTopicMirrorData _duplicate = new ClearTopicMirrorData();
            _duplicate.topic = this.topic;
            return _duplicate;
        }

        public String toString() {
            return "ClearTopicMirrorData(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ")";
        }

        public String topic() {
            return this.topic;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ClearTopicMirrorData setTopic(String v) {
            this.topic = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class StopTopicMirrorData
    implements Message {
        String topic;
        boolean synchronize;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("synchronize", Type.BOOLEAN, "Whether to synchronize with the source topic before stopping mirroring."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public StopTopicMirrorData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public StopTopicMirrorData() {
            this.topic = "";
            this.synchronize = true;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.synchronize = _version >= 1 ? _readable.readByte() != 0 : true;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            if (_version >= 1) {
                _writable.writeByte(this.synchronize ? (byte)1 : 0);
            } else if (!this.synchronize) {
                throw new UnsupportedVersionException("Attempted to write a non-default synchronize at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (_version >= 1) {
                _size.addBytes(1);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopTopicMirrorData)) {
                return false;
            }
            StopTopicMirrorData other = (StopTopicMirrorData)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.synchronize != other.synchronize) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.synchronize ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public StopTopicMirrorData duplicate() {
            StopTopicMirrorData _duplicate = new StopTopicMirrorData();
            _duplicate.topic = this.topic;
            _duplicate.synchronize = this.synchronize;
            return _duplicate;
        }

        public String toString() {
            return "StopTopicMirrorData(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", synchronize=" + (this.synchronize ? "true" : "false") + ")";
        }

        public String topic() {
            return this.topic;
        }

        public boolean synchronize() {
            return this.synchronize;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public StopTopicMirrorData setTopic(String v) {
            this.topic = v;
            return this;
        }

        public StopTopicMirrorData setSynchronize(boolean v) {
            this.synchronize = v;
            return this;
        }
    }

    public static class OpData
    implements Message {
        List<StopTopicMirrorData> stopTopicMirror;
        List<ClearTopicMirrorData> clearTopicMirror;
        List<PauseTopicMirrorData> pauseTopicMirror;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("stop_topic_mirror", CompactArrayOf.nullable(StopTopicMirrorData.SCHEMA_0), "Stops a topic's mirroring to become a writable topic."), new Field("clear_topic_mirror", CompactArrayOf.nullable(ClearTopicMirrorData.SCHEMA_0), "Clears a topic's mirror information."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("stop_topic_mirror", CompactArrayOf.nullable(StopTopicMirrorData.SCHEMA_1), "Stops a topic's mirroring to become a writable topic."), new Field("clear_topic_mirror", CompactArrayOf.nullable(ClearTopicMirrorData.SCHEMA_0), "Clears a topic's mirror information."), new Field("pause_topic_mirror", CompactArrayOf.nullable(PauseTopicMirrorData.SCHEMA_1), "Pauses a mirror topic's replication."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public OpData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public OpData() {
            this.stopTopicMirror = null;
            this.clearTopicMirror = null;
            this.pauseTopicMirror = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<StopTopicMirrorData> newCollection;
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.stopTopicMirror = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<StopTopicMirrorData>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new StopTopicMirrorData(_readable, _version, _context));
                }
                this.stopTopicMirror = newCollection;
            }
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.clearTopicMirror = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((StopTopicMirrorData)((Object)new ClearTopicMirrorData(_readable, _version, _context)));
                }
                this.clearTopicMirror = newCollection;
            }
            if (_version >= 1) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.pauseTopicMirror = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add((StopTopicMirrorData)((Object)new PauseTopicMirrorData(_readable, _version, _context)));
                    }
                    this.pauseTopicMirror = newCollection;
                }
            } else {
                this.pauseTopicMirror = null;
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OpData");
            }
            int _numTaggedFields = 0;
            if (this.stopTopicMirror == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.stopTopicMirror.size() + 1);
                for (StopTopicMirrorData stopTopicMirrorElement : this.stopTopicMirror) {
                    stopTopicMirrorElement.write(_writable, _cache, _version, _context);
                }
            }
            if (this.clearTopicMirror == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.clearTopicMirror.size() + 1);
                for (ClearTopicMirrorData clearTopicMirrorElement : this.clearTopicMirror) {
                    clearTopicMirrorElement.write(_writable, _cache, _version, _context);
                }
            }
            if (_version >= 1) {
                if (this.pauseTopicMirror == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.pauseTopicMirror.size() + 1);
                    for (PauseTopicMirrorData pauseTopicMirrorElement : this.pauseTopicMirror) {
                        pauseTopicMirrorElement.write(_writable, _cache, _version, _context);
                    }
                }
            } else if (this.pauseTopicMirror != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default pauseTopicMirror at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (this.stopTopicMirror == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.stopTopicMirror.size() + 1));
                for (StopTopicMirrorData stopTopicMirrorElement : this.stopTopicMirror) {
                    stopTopicMirrorElement.addSize(_size, _cache, _version, _context);
                }
            }
            if (this.clearTopicMirror == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.clearTopicMirror.size() + 1));
                for (ClearTopicMirrorData clearTopicMirrorElement : this.clearTopicMirror) {
                    clearTopicMirrorElement.addSize(_size, _cache, _version, _context);
                }
            }
            if (_version >= 1) {
                if (this.pauseTopicMirror == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.pauseTopicMirror.size() + 1));
                    for (PauseTopicMirrorData pauseTopicMirrorElement : this.pauseTopicMirror) {
                        pauseTopicMirrorElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OpData)) {
                return false;
            }
            OpData other = (OpData)obj;
            if (this.stopTopicMirror == null ? other.stopTopicMirror != null : !this.stopTopicMirror.equals(other.stopTopicMirror)) {
                return false;
            }
            if (this.clearTopicMirror == null ? other.clearTopicMirror != null : !this.clearTopicMirror.equals(other.clearTopicMirror)) {
                return false;
            }
            if (this.pauseTopicMirror == null ? other.pauseTopicMirror != null : !this.pauseTopicMirror.equals(other.pauseTopicMirror)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.stopTopicMirror == null ? 0 : this.stopTopicMirror.hashCode());
            hashCode = 31 * hashCode + (this.clearTopicMirror == null ? 0 : this.clearTopicMirror.hashCode());
            hashCode = 31 * hashCode + (this.pauseTopicMirror == null ? 0 : this.pauseTopicMirror.hashCode());
            return hashCode;
        }

        @Override
        public OpData duplicate() {
            OpData _duplicate = new OpData();
            if (this.stopTopicMirror == null) {
                _duplicate.stopTopicMirror = null;
            } else {
                ArrayList<StopTopicMirrorData> newStopTopicMirror = new ArrayList<StopTopicMirrorData>(this.stopTopicMirror.size());
                for (StopTopicMirrorData stopTopicMirrorData : this.stopTopicMirror) {
                    newStopTopicMirror.add(stopTopicMirrorData.duplicate());
                }
                _duplicate.stopTopicMirror = newStopTopicMirror;
            }
            if (this.clearTopicMirror == null) {
                _duplicate.clearTopicMirror = null;
            } else {
                ArrayList<ClearTopicMirrorData> newClearTopicMirror = new ArrayList<ClearTopicMirrorData>(this.clearTopicMirror.size());
                for (ClearTopicMirrorData clearTopicMirrorData : this.clearTopicMirror) {
                    newClearTopicMirror.add(clearTopicMirrorData.duplicate());
                }
                _duplicate.clearTopicMirror = newClearTopicMirror;
            }
            if (this.pauseTopicMirror == null) {
                _duplicate.pauseTopicMirror = null;
            } else {
                ArrayList<PauseTopicMirrorData> newPauseTopicMirror = new ArrayList<PauseTopicMirrorData>(this.pauseTopicMirror.size());
                for (PauseTopicMirrorData pauseTopicMirrorData : this.pauseTopicMirror) {
                    newPauseTopicMirror.add(pauseTopicMirrorData.duplicate());
                }
                _duplicate.pauseTopicMirror = newPauseTopicMirror;
            }
            return _duplicate;
        }

        public String toString() {
            return "OpData(stopTopicMirror=" + (this.stopTopicMirror == null ? "null" : MessageUtil.deepToString(this.stopTopicMirror.iterator())) + ", clearTopicMirror=" + (this.clearTopicMirror == null ? "null" : MessageUtil.deepToString(this.clearTopicMirror.iterator())) + ", pauseTopicMirror=" + (this.pauseTopicMirror == null ? "null" : MessageUtil.deepToString(this.pauseTopicMirror.iterator())) + ")";
        }

        public List<StopTopicMirrorData> stopTopicMirror() {
            return this.stopTopicMirror;
        }

        public List<ClearTopicMirrorData> clearTopicMirror() {
            return this.clearTopicMirror;
        }

        public List<PauseTopicMirrorData> pauseTopicMirror() {
            return this.pauseTopicMirror;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OpData setStopTopicMirror(List<StopTopicMirrorData> v) {
            this.stopTopicMirror = v;
            return this;
        }

        public OpData setClearTopicMirror(List<ClearTopicMirrorData> v) {
            this.clearTopicMirror = v;
            return this;
        }

        public OpData setPauseTopicMirror(List<PauseTopicMirrorData> v) {
            this.pauseTopicMirror = v;
            return this;
        }
    }
}

