/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class ClusterLinkListing {
    private final String linkName;
    private final UUID linkId;
    private final String remoteClusterId;
    private final String localClusterId;
    private final Optional<Collection<String>> topics;

    public ClusterLinkListing(String linkName, UUID linkId, String remoteClusterId, Optional<Collection<String>> topics) {
        this(linkName, linkId, remoteClusterId, null, topics);
    }

    public ClusterLinkListing(String linkName, UUID linkId, String remoteClusterId, String localClusterId, Optional<Collection<String>> topics) {
        this.linkName = Objects.requireNonNull(linkName, "linkName");
        this.linkId = Objects.requireNonNull(linkId, "linkId");
        this.remoteClusterId = remoteClusterId;
        this.localClusterId = localClusterId;
        this.topics = Objects.requireNonNull(topics, "topics");
    }

    public String linkName() {
        return this.linkName;
    }

    public UUID linkId() {
        return this.linkId;
    }

    public String clusterId() {
        return this.remoteClusterId();
    }

    public String remoteClusterId() {
        return this.remoteClusterId;
    }

    public String localClusterId() {
        return this.localClusterId;
    }

    public Optional<Collection<String>> topics() {
        return this.topics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterLinkListing that = (ClusterLinkListing)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.remoteClusterId, that.remoteClusterId) && Objects.equals(this.localClusterId, that.localClusterId) && Objects.equals(this.topics, that.topics);
    }

    public int hashCode() {
        return Objects.hash(this.linkName, this.linkId, this.remoteClusterId, this.localClusterId, this.topics);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ClusterLinkListing(linkName=").append(this.linkName).append(", linkId=").append(this.linkId).append(", remoteClusterId=").append(this.remoteClusterId).append(", localClusterId=").append(this.localClusterId);
        if (this.topics.isPresent()) {
            str.append(", topics=").append(this.topics.get());
        }
        return str.toString();
    }
}

