/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class WriteTxnMarkersRequestData
implements ApiMessage {
    List<WritableTxnMarker> markers;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("markers", new ArrayOf(WritableTxnMarker.SCHEMA_0), "The transaction markers to be written."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public WriteTxnMarkersRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public WriteTxnMarkersRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public WriteTxnMarkersRequestData() {
        this.markers = new ArrayList<WritableTxnMarker>(0);
    }

    @Override
    public short apiKey() {
        return 27;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field markers was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<WritableTxnMarker> newCollection = new ArrayList<WritableTxnMarker>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new WritableTxnMarker(_readable, _version));
        }
        this.markers = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.markers.size());
        for (WritableTxnMarker markersElement : this.markers) {
            markersElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        Object[] _nestedObjects = struct.getArray("markers");
        this.markers = new ArrayList<WritableTxnMarker>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.markers.add(new WritableTxnMarker((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.markers.size()];
        int i = 0;
        for (WritableTxnMarker element : this.markers) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("markers", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += 4;
        for (WritableTxnMarker markersElement : this.markers) {
            _arraySize += markersElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WriteTxnMarkersRequestData)) {
            return false;
        }
        WriteTxnMarkersRequestData other = (WriteTxnMarkersRequestData)obj;
        if (this.markers == null ? other.markers != null : !this.markers.equals(other.markers)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.markers == null ? 0 : this.markers.hashCode());
        return hashCode;
    }

    @Override
    public WriteTxnMarkersRequestData duplicate() {
        WriteTxnMarkersRequestData _duplicate = new WriteTxnMarkersRequestData();
        ArrayList<WritableTxnMarker> newMarkers = new ArrayList<WritableTxnMarker>(this.markers.size());
        for (WritableTxnMarker _element : this.markers) {
            newMarkers.add(_element.duplicate());
        }
        _duplicate.markers = newMarkers;
        return _duplicate;
    }

    public String toString() {
        return "WriteTxnMarkersRequestData(markers=" + MessageUtil.deepToString(this.markers.iterator()) + ")";
    }

    public List<WritableTxnMarker> markers() {
        return this.markers;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public WriteTxnMarkersRequestData setMarkers(List<WritableTxnMarker> v) {
        this.markers = v;
        return this;
    }

    public static class WritableTxnMarkerTopic
    implements Message {
        String name;
        List<Integer> partitionIndexes;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partition_indexes", new ArrayOf(Type.INT32), "The indexes of the partitions to write transaction markers for."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public WritableTxnMarkerTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public WritableTxnMarkerTopic(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public WritableTxnMarkerTopic() {
            this.name = "";
            this.partitionIndexes = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of WritableTxnMarkerTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionIndexes was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitionIndexes = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitionIndexes.size());
            _stringBytes = this.partitionIndexes.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionIndexesElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionIndexesElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of WritableTxnMarkerTopic");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partition_indexes");
            this.partitionIndexes = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitionIndexes.add((Integer)nestedObject);
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of WritableTxnMarkerTopic");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Integer[] _nestedObjects = new Integer[this.partitionIndexes.size()];
            int i = 0;
            for (Integer element : this.partitionIndexes) {
                _nestedObjects[i++] = element;
            }
            struct.set("partition_indexes", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of WritableTxnMarkerTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            _size += (_arraySize += this.partitionIndexes.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WritableTxnMarkerTopic)) {
                return false;
            }
            WritableTxnMarkerTopic other = (WritableTxnMarkerTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitionIndexes == null ? other.partitionIndexes != null : !this.partitionIndexes.equals(other.partitionIndexes)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitionIndexes == null ? 0 : this.partitionIndexes.hashCode());
            return hashCode;
        }

        @Override
        public WritableTxnMarkerTopic duplicate() {
            WritableTxnMarkerTopic _duplicate = new WritableTxnMarkerTopic();
            _duplicate.name = this.name;
            ArrayList<Integer> newPartitionIndexes = new ArrayList<Integer>(this.partitionIndexes.size());
            for (Integer _element : this.partitionIndexes) {
                newPartitionIndexes.add(_element);
            }
            _duplicate.partitionIndexes = newPartitionIndexes;
            return _duplicate;
        }

        public String toString() {
            return "WritableTxnMarkerTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitionIndexes=" + MessageUtil.deepToString(this.partitionIndexes.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitionIndexes() {
            return this.partitionIndexes;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public WritableTxnMarkerTopic setName(String v) {
            this.name = v;
            return this;
        }

        public WritableTxnMarkerTopic setPartitionIndexes(List<Integer> v) {
            this.partitionIndexes = v;
            return this;
        }
    }

    public static class WritableTxnMarker
    implements Message {
        long producerId;
        short producerEpoch;
        boolean transactionResult;
        List<WritableTxnMarkerTopic> topics;
        int coordinatorEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("producer_id", Type.INT64, "The current producer ID."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer ID."), new Field("transaction_result", Type.BOOLEAN, "The result of the transaction to write to the partitions (false = ABORT, true = COMMIT)."), new Field("topics", new ArrayOf(WritableTxnMarkerTopic.SCHEMA_0), "Each topic that we want to write transaction marker(s) for."), new Field("coordinator_epoch", Type.INT32, "Epoch associated with the transaction state partition hosted by this transaction coordinator"));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public WritableTxnMarker(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public WritableTxnMarker(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public WritableTxnMarker() {
            this.producerId = 0L;
            this.producerEpoch = 0;
            this.transactionResult = false;
            this.topics = new ArrayList<WritableTxnMarkerTopic>(0);
            this.coordinatorEpoch = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of WritableTxnMarker");
            }
            this.producerId = _readable.readLong();
            this.producerEpoch = _readable.readShort();
            this.transactionResult = _readable.readByte() != 0;
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<WritableTxnMarkerTopic> newCollection = new ArrayList<WritableTxnMarkerTopic>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new WritableTxnMarkerTopic(_readable, _version));
            }
            this.topics = newCollection;
            this.coordinatorEpoch = _readable.readInt();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeLong(this.producerId);
            _writable.writeShort(this.producerEpoch);
            _writable.writeByte(this.transactionResult ? (byte)1 : 0);
            _writable.writeInt(this.topics.size());
            for (WritableTxnMarkerTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
            _writable.writeInt(this.coordinatorEpoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of WritableTxnMarker");
            }
            this._unknownTaggedFields = null;
            this.producerId = struct.getLong("producer_id");
            this.producerEpoch = struct.getShort("producer_epoch");
            this.transactionResult = struct.getBoolean("transaction_result");
            Object[] _nestedObjects = struct.getArray("topics");
            this.topics = new ArrayList<WritableTxnMarkerTopic>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topics.add(new WritableTxnMarkerTopic((Struct)nestedObject, _version));
            }
            this.coordinatorEpoch = struct.getInt("coordinator_epoch");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of WritableTxnMarker");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("producer_id", (Object)this.producerId);
            struct.set("producer_epoch", (Object)this.producerEpoch);
            struct.set("transaction_result", (Object)this.transactionResult);
            Struct[] _nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (WritableTxnMarkerTopic element : this.topics) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("topics", (Object)_nestedObjects);
            struct.set("coordinator_epoch", (Object)this.coordinatorEpoch);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of WritableTxnMarker");
            }
            _size += 8;
            _size += 2;
            ++_size;
            int _arraySize = 0;
            _arraySize += 4;
            for (WritableTxnMarkerTopic topicsElement : this.topics) {
                _arraySize += topicsElement.size(_cache, _version);
            }
            _size += _arraySize;
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WritableTxnMarker)) {
                return false;
            }
            WritableTxnMarker other = (WritableTxnMarker)obj;
            if (this.producerId != other.producerId) {
                return false;
            }
            if (this.producerEpoch != other.producerEpoch) {
                return false;
            }
            if (this.transactionResult != other.transactionResult) {
                return false;
            }
            if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
                return false;
            }
            if (this.coordinatorEpoch != other.coordinatorEpoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
            hashCode = 31 * hashCode + this.producerEpoch;
            hashCode = 31 * hashCode + (this.transactionResult ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
            hashCode = 31 * hashCode + this.coordinatorEpoch;
            return hashCode;
        }

        @Override
        public WritableTxnMarker duplicate() {
            WritableTxnMarker _duplicate = new WritableTxnMarker();
            _duplicate.producerId = this.producerId;
            _duplicate.producerEpoch = this.producerEpoch;
            _duplicate.transactionResult = this.transactionResult;
            ArrayList<WritableTxnMarkerTopic> newTopics = new ArrayList<WritableTxnMarkerTopic>(this.topics.size());
            for (WritableTxnMarkerTopic _element : this.topics) {
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
            _duplicate.coordinatorEpoch = this.coordinatorEpoch;
            return _duplicate;
        }

        public String toString() {
            return "WritableTxnMarker(producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", transactionResult=" + (this.transactionResult ? "true" : "false") + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", coordinatorEpoch=" + this.coordinatorEpoch + ")";
        }

        public long producerId() {
            return this.producerId;
        }

        public short producerEpoch() {
            return this.producerEpoch;
        }

        public boolean transactionResult() {
            return this.transactionResult;
        }

        public List<WritableTxnMarkerTopic> topics() {
            return this.topics;
        }

        public int coordinatorEpoch() {
            return this.coordinatorEpoch;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public WritableTxnMarker setProducerId(long v) {
            this.producerId = v;
            return this;
        }

        public WritableTxnMarker setProducerEpoch(short v) {
            this.producerEpoch = v;
            return this;
        }

        public WritableTxnMarker setTransactionResult(boolean v) {
            this.transactionResult = v;
            return this;
        }

        public WritableTxnMarker setTopics(List<WritableTxnMarkerTopic> v) {
            this.topics = v;
            return this;
        }

        public WritableTxnMarker setCoordinatorEpoch(int v) {
            this.coordinatorEpoch = v;
            return this;
        }
    }
}

