/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DeleteAclsRequestData
implements ApiMessage {
    List<DeleteAclsFilter> filters;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("filters", (Type)new ArrayOf((Type)DeleteAclsFilter.SCHEMA_0), "The filters to use when deleting ACLs.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("filters", (Type)new ArrayOf((Type)DeleteAclsFilter.SCHEMA_1), "The filters to use when deleting ACLs.")});
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public DeleteAclsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DeleteAclsRequestData() {
        this.filters = new ArrayList<DeleteAclsFilter>(0);
    }

    public short apiKey() {
        return 31;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 3;
    }

    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<DeleteAclsFilter> newCollection;
        int arrayLength;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field filters was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteAclsFilter(_readable, _version));
            }
            this.filters = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field filters was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<DeleteAclsFilter>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteAclsFilter(_readable, _version));
            }
            this.filters = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.filters.size() + 1);
            for (DeleteAclsFilter filtersElement : this.filters) {
                filtersElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.filters.size());
            for (DeleteAclsFilter filtersElement : this.filters) {
                filtersElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.filters.size() + 1)));
        } else {
            _size.addBytes(4);
        }
        for (DeleteAclsFilter filtersElement : this.filters) {
            filtersElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteAclsRequestData)) {
            return false;
        }
        DeleteAclsRequestData other = (DeleteAclsRequestData)obj;
        if (this.filters == null ? other.filters != null : !this.filters.equals(other.filters)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.filters == null ? 0 : this.filters.hashCode());
        return hashCode;
    }

    public DeleteAclsRequestData duplicate() {
        DeleteAclsRequestData _duplicate = new DeleteAclsRequestData();
        ArrayList<DeleteAclsFilter> newFilters = new ArrayList<DeleteAclsFilter>(this.filters.size());
        for (DeleteAclsFilter _element : this.filters) {
            newFilters.add(_element.duplicate());
        }
        _duplicate.filters = newFilters;
        return _duplicate;
    }

    public String toString() {
        return "DeleteAclsRequestData(filters=" + MessageUtil.deepToString(this.filters.iterator()) + ")";
    }

    public List<DeleteAclsFilter> filters() {
        return this.filters;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteAclsRequestData setFilters(List<DeleteAclsFilter> v) {
        this.filters = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("filters", (Type)new CompactArrayOf((Type)DeleteAclsFilter.SCHEMA_2), "The filters to use when deleting ACLs."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class DeleteAclsFilter
    implements Message {
        byte resourceTypeFilter;
        String resourceNameFilter;
        byte patternTypeFilter;
        String principalFilter;
        String hostFilter;
        byte operation;
        byte permissionType;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("resource_type_filter", (Type)Type.INT8, "The resource type."), new Field("resource_name_filter", (Type)Type.NULLABLE_STRING, "The resource name."), new Field("principal_filter", (Type)Type.NULLABLE_STRING, "The principal filter, or null to accept all principals."), new Field("host_filter", (Type)Type.NULLABLE_STRING, "The host filter, or null to accept all hosts."), new Field("operation", (Type)Type.INT8, "The ACL operation."), new Field("permission_type", (Type)Type.INT8, "The permission type.")});
        public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("resource_type_filter", (Type)Type.INT8, "The resource type."), new Field("resource_name_filter", (Type)Type.NULLABLE_STRING, "The resource name."), new Field("pattern_type_filter", (Type)Type.INT8, "The pattern type."), new Field("principal_filter", (Type)Type.NULLABLE_STRING, "The principal filter, or null to accept all principals."), new Field("host_filter", (Type)Type.NULLABLE_STRING, "The host filter, or null to accept all hosts."), new Field("operation", (Type)Type.INT8, "The ACL operation."), new Field("permission_type", (Type)Type.INT8, "The permission type.")});
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public DeleteAclsFilter(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DeleteAclsFilter() {
            this.resourceTypeFilter = 0;
            this.resourceNameFilter = "";
            this.patternTypeFilter = (byte)3;
            this.principalFilter = "";
            this.hostFilter = "";
            this.operation = 0;
            this.permissionType = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteAclsFilter");
            }
            this.resourceTypeFilter = _readable.readByte();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.resourceNameFilter = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field resourceNameFilter had invalid length " + length);
                }
                this.resourceNameFilter = _readable.readString(length);
            }
            this.patternTypeFilter = _version >= 1 ? _readable.readByte() : (byte)3;
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.principalFilter = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field principalFilter had invalid length " + length);
                }
                this.principalFilter = _readable.readString(length);
            }
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.hostFilter = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field hostFilter had invalid length " + length);
                }
                this.hostFilter = _readable.readString(length);
            }
            this.operation = _readable.readByte();
            this.permissionType = _readable.readByte();
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeByte(this.resourceTypeFilter);
            if (this.resourceNameFilter == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.resourceNameFilter);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            if (_version >= 1) {
                _writable.writeByte(this.patternTypeFilter);
            } else if (this.patternTypeFilter != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternTypeFilter at version " + _version);
            }
            if (this.principalFilter == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.principalFilter);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            if (this.hostFilter == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.hostFilter);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeByte(this.operation);
            _writable.writeByte(this.permissionType);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteAclsFilter");
            }
            _size.addBytes(1);
            if (this.resourceNameFilter == null) {
                if (_version >= 2) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.resourceNameFilter.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'resourceNameFilter' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.resourceNameFilter, _stringBytes);
                if (_version >= 2) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (_version >= 1) {
                _size.addBytes(1);
            }
            if (this.principalFilter == null) {
                if (_version >= 2) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.principalFilter.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'principalFilter' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.principalFilter, _stringBytes);
                if (_version >= 2) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (this.hostFilter == null) {
                if (_version >= 2) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.hostFilter.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'hostFilter' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.hostFilter, _stringBytes);
                if (_version >= 2) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            _size.addBytes(1);
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteAclsFilter)) {
                return false;
            }
            DeleteAclsFilter other = (DeleteAclsFilter)obj;
            if (this.resourceTypeFilter != other.resourceTypeFilter) {
                return false;
            }
            if (this.resourceNameFilter == null ? other.resourceNameFilter != null : !this.resourceNameFilter.equals(other.resourceNameFilter)) {
                return false;
            }
            if (this.patternTypeFilter != other.patternTypeFilter) {
                return false;
            }
            if (this.principalFilter == null ? other.principalFilter != null : !this.principalFilter.equals(other.principalFilter)) {
                return false;
            }
            if (this.hostFilter == null ? other.hostFilter != null : !this.hostFilter.equals(other.hostFilter)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            if (this.permissionType != other.permissionType) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceTypeFilter;
            hashCode = 31 * hashCode + (this.resourceNameFilter == null ? 0 : this.resourceNameFilter.hashCode());
            hashCode = 31 * hashCode + this.patternTypeFilter;
            hashCode = 31 * hashCode + (this.principalFilter == null ? 0 : this.principalFilter.hashCode());
            hashCode = 31 * hashCode + (this.hostFilter == null ? 0 : this.hostFilter.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            return hashCode;
        }

        public DeleteAclsFilter duplicate() {
            DeleteAclsFilter _duplicate = new DeleteAclsFilter();
            _duplicate.resourceTypeFilter = this.resourceTypeFilter;
            _duplicate.resourceNameFilter = this.resourceNameFilter == null ? null : this.resourceNameFilter;
            _duplicate.patternTypeFilter = this.patternTypeFilter;
            _duplicate.principalFilter = this.principalFilter == null ? null : this.principalFilter;
            _duplicate.hostFilter = this.hostFilter == null ? null : this.hostFilter;
            _duplicate.operation = this.operation;
            _duplicate.permissionType = this.permissionType;
            return _duplicate;
        }

        public String toString() {
            return "DeleteAclsFilter(resourceTypeFilter=" + this.resourceTypeFilter + ", resourceNameFilter=" + (this.resourceNameFilter == null ? "null" : "'" + this.resourceNameFilter.toString() + "'") + ", patternTypeFilter=" + this.patternTypeFilter + ", principalFilter=" + (this.principalFilter == null ? "null" : "'" + this.principalFilter.toString() + "'") + ", hostFilter=" + (this.hostFilter == null ? "null" : "'" + this.hostFilter.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
        }

        public byte resourceTypeFilter() {
            return this.resourceTypeFilter;
        }

        public String resourceNameFilter() {
            return this.resourceNameFilter;
        }

        public byte patternTypeFilter() {
            return this.patternTypeFilter;
        }

        public String principalFilter() {
            return this.principalFilter;
        }

        public String hostFilter() {
            return this.hostFilter;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteAclsFilter setResourceTypeFilter(byte v) {
            this.resourceTypeFilter = v;
            return this;
        }

        public DeleteAclsFilter setResourceNameFilter(String v) {
            this.resourceNameFilter = v;
            return this;
        }

        public DeleteAclsFilter setPatternTypeFilter(byte v) {
            this.patternTypeFilter = v;
            return this;
        }

        public DeleteAclsFilter setPrincipalFilter(String v) {
            this.principalFilter = v;
            return this;
        }

        public DeleteAclsFilter setHostFilter(String v) {
            this.hostFilter = v;
            return this;
        }

        public DeleteAclsFilter setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public DeleteAclsFilter setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("resource_type_filter", (Type)Type.INT8, "The resource type."), new Field("resource_name_filter", (Type)Type.COMPACT_NULLABLE_STRING, "The resource name."), new Field("pattern_type_filter", (Type)Type.INT8, "The pattern type."), new Field("principal_filter", (Type)Type.COMPACT_NULLABLE_STRING, "The principal filter, or null to accept all principals."), new Field("host_filter", (Type)Type.COMPACT_NULLABLE_STRING, "The host filter, or null to accept all hosts."), new Field("operation", (Type)Type.INT8, "The ACL operation."), new Field("permission_type", (Type)Type.INT8, "The permission type."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

