/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;

public class DeleteAclsRequestTest {
    private static final short V0 = 0;
    private static final short V1 = 1;
    private static final AclBindingFilter LITERAL_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "foo", PatternType.LITERAL), new AccessControlEntryFilter("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.DENY));
    private static final AclBindingFilter PREFIXED_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.GROUP, "prefix", PatternType.PREFIXED), new AccessControlEntryFilter("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));
    private static final AclBindingFilter ANY_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.GROUP, "bar", PatternType.ANY), new AccessControlEntryFilter("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));
    private static final AclBindingFilter UNKNOWN_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.UNKNOWN, "prefix", PatternType.PREFIXED), new AccessControlEntryFilter("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));

    @Test
    public void shouldThrowOnV0IfPrefixed() {
        Assert.assertThrows(UnsupportedVersionException.class, () -> new DeleteAclsRequest.Builder(DeleteAclsRequestTest.requestData(PREFIXED_FILTER)).build((short)0));
    }

    @Test
    public void shouldThrowOnUnknownElements() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new DeleteAclsRequest.Builder(DeleteAclsRequestTest.requestData(UNKNOWN_FILTER)).build((short)1));
    }

    @Test
    public void shouldRoundTripLiteralV0() {
        DeleteAclsRequest original = new DeleteAclsRequest.Builder(DeleteAclsRequestTest.requestData(LITERAL_FILTER)).build((short)0);
        Struct struct = original.toStruct();
        DeleteAclsRequest result = new DeleteAclsRequest(struct, 0);
        DeleteAclsRequestTest.assertRequestEquals(original, result);
    }

    @Test
    public void shouldRoundTripAnyV0AsLiteral() {
        DeleteAclsRequest original = new DeleteAclsRequest.Builder(DeleteAclsRequestTest.requestData(ANY_FILTER)).build((short)0);
        DeleteAclsRequest expected = new DeleteAclsRequest.Builder(DeleteAclsRequestTest.requestData(new AclBindingFilter(new ResourcePatternFilter(ANY_FILTER.patternFilter().resourceType(), ANY_FILTER.patternFilter().name(), PatternType.LITERAL), ANY_FILTER.entryFilter()))).build((short)0);
        DeleteAclsRequest result = new DeleteAclsRequest(original.toStruct(), 0);
        DeleteAclsRequestTest.assertRequestEquals(expected, result);
    }

    @Test
    public void shouldRoundTripV1() {
        DeleteAclsRequest original = new DeleteAclsRequest.Builder(DeleteAclsRequestTest.requestData(LITERAL_FILTER, PREFIXED_FILTER, ANY_FILTER)).build((short)1);
        Struct struct = original.toStruct();
        DeleteAclsRequest result = new DeleteAclsRequest(struct, 1);
        DeleteAclsRequestTest.assertRequestEquals(original, result);
    }

    private static void assertRequestEquals(DeleteAclsRequest original, DeleteAclsRequest actual) {
        Assert.assertEquals((String)"Number of filters wrong", (long)original.filters().size(), (long)actual.filters().size());
        for (int idx = 0; idx != original.filters().size(); ++idx) {
            AclBindingFilter originalFilter = (AclBindingFilter)original.filters().get(idx);
            AclBindingFilter actualFilter = (AclBindingFilter)actual.filters().get(idx);
            Assert.assertEquals((Object)originalFilter, (Object)actualFilter);
        }
    }

    private static DeleteAclsRequestData requestData(AclBindingFilter ... acls) {
        return new DeleteAclsRequestData().setFilters(Arrays.asList(acls).stream().map(DeleteAclsRequest::deleteAclsFilter).collect(Collectors.toList()));
    }
}

