/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ByteUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultRecordTest {
    private byte[] skipArray;

    @Before
    public void setUp() {
        this.skipArray = new byte[64];
    }

    @Test
    public void testBasicSerde() throws IOException {
        SimpleRecord[] records;
        Header[] headers = new Header[]{new RecordHeader("foo", "value".getBytes()), new RecordHeader("bar", (byte[])null), new RecordHeader("\"A\\u00ea\\u00f1\\u00fcC\"", "value".getBytes())};
        for (SimpleRecord record : records = new SimpleRecord[]{new SimpleRecord("hi".getBytes(), "there".getBytes()), new SimpleRecord(null, "there".getBytes()), new SimpleRecord("hi".getBytes(), null), new SimpleRecord(null, null), new SimpleRecord(15L, "hi".getBytes(), "there".getBytes(), headers)}) {
            int baseSequence = 723;
            long baseOffset = 37L;
            int offsetDelta = 10;
            long baseTimestamp = System.currentTimeMillis();
            long timestampDelta = 323L;
            ByteBufferOutputStream out = new ByteBufferOutputStream(1024);
            DefaultRecord.writeTo((DataOutputStream)new DataOutputStream((OutputStream)out), (int)offsetDelta, (long)timestampDelta, (ByteBuffer)record.key(), (ByteBuffer)record.value(), (Header[])record.headers());
            ByteBuffer buffer = out.buffer();
            buffer.flip();
            DefaultRecord logRecord = DefaultRecord.readFrom((ByteBuffer)buffer, (long)baseOffset, (long)baseTimestamp, (int)baseSequence, null);
            Assert.assertNotNull((Object)logRecord);
            Assert.assertEquals((long)(baseOffset + (long)offsetDelta), (long)logRecord.offset());
            Assert.assertEquals((long)(baseSequence + offsetDelta), (long)logRecord.sequence());
            Assert.assertEquals((long)(baseTimestamp + timestampDelta), (long)logRecord.timestamp());
            Assert.assertEquals((Object)record.key(), (Object)logRecord.key());
            Assert.assertEquals((Object)record.value(), (Object)logRecord.value());
            Assert.assertArrayEquals((Object[])record.headers(), (Object[])logRecord.headers());
            Assert.assertEquals((long)DefaultRecord.sizeInBytes((int)offsetDelta, (long)timestampDelta, (ByteBuffer)record.key(), (ByteBuffer)record.value(), (Header[])record.headers()), (long)logRecord.sizeInBytes());
        }
    }

    @Test(expected=InvalidRecordException.class)
    public void testBasicSerdeInvalidHeaderCountTooHigh() throws IOException {
        Header[] headers = new Header[]{new RecordHeader("foo", "value".getBytes()), new RecordHeader("bar", (byte[])null), new RecordHeader("\"A\\u00ea\\u00f1\\u00fcC\"", "value".getBytes())};
        SimpleRecord record = new SimpleRecord(15L, "hi".getBytes(), "there".getBytes(), headers);
        int baseSequence = 723;
        long baseOffset = 37L;
        int offsetDelta = 10;
        long baseTimestamp = System.currentTimeMillis();
        long timestampDelta = 323L;
        ByteBufferOutputStream out = new ByteBufferOutputStream(1024);
        DefaultRecord.writeTo((DataOutputStream)new DataOutputStream((OutputStream)out), (int)offsetDelta, (long)timestampDelta, (ByteBuffer)record.key(), (ByteBuffer)record.value(), (Header[])record.headers());
        ByteBuffer buffer = out.buffer();
        buffer.flip();
        buffer.put(14, (byte)8);
        DefaultRecord logRecord = DefaultRecord.readFrom((ByteBuffer)buffer, (long)baseOffset, (long)baseTimestamp, (int)baseSequence, null);
        Assert.assertEquals((long)DefaultRecord.sizeInBytes((int)offsetDelta, (long)timestampDelta, (ByteBuffer)record.key(), (ByteBuffer)record.value(), (Header[])record.headers()), (long)logRecord.sizeInBytes());
    }

    @Test(expected=InvalidRecordException.class)
    public void testBasicSerdeInvalidHeaderCountTooLow() throws IOException {
        Header[] headers = new Header[]{new RecordHeader("foo", "value".getBytes()), new RecordHeader("bar", (byte[])null), new RecordHeader("\"A\\u00ea\\u00f1\\u00fcC\"", "value".getBytes())};
        SimpleRecord record = new SimpleRecord(15L, "hi".getBytes(), "there".getBytes(), headers);
        int baseSequence = 723;
        long baseOffset = 37L;
        int offsetDelta = 10;
        long baseTimestamp = System.currentTimeMillis();
        long timestampDelta = 323L;
        ByteBufferOutputStream out = new ByteBufferOutputStream(1024);
        DefaultRecord.writeTo((DataOutputStream)new DataOutputStream((OutputStream)out), (int)offsetDelta, (long)timestampDelta, (ByteBuffer)record.key(), (ByteBuffer)record.value(), (Header[])record.headers());
        ByteBuffer buffer = out.buffer();
        buffer.flip();
        buffer.put(14, (byte)4);
        DefaultRecord logRecord = DefaultRecord.readFrom((ByteBuffer)buffer, (long)baseOffset, (long)baseTimestamp, (int)baseSequence, null);
        Assert.assertEquals((long)DefaultRecord.sizeInBytes((int)offsetDelta, (long)timestampDelta, (ByteBuffer)record.key(), (ByteBuffer)record.value(), (Header[])record.headers()), (long)logRecord.sizeInBytes());
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidKeySize() {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        int keySize = 105;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)keySize, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DefaultRecord.readFrom((ByteBuffer)buf, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidKeySizePartial() throws IOException {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        int keySize = 105;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)keySize, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DataInputStream inputStream = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        DefaultRecord.readPartiallyFrom((DataInput)inputStream, (byte[])this.skipArray, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidValueSize() throws IOException {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        int valueSize = 105;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)valueSize, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DefaultRecord.readFrom((ByteBuffer)buf, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidValueSizePartial() throws IOException {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        int valueSize = 105;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)valueSize, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DataInputStream inputStream = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        DefaultRecord.readPartiallyFrom((DataInput)inputStream, (byte[])this.skipArray, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidNumHeaders() throws IOException {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DefaultRecord.readFrom((ByteBuffer)buf, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidNumHeadersPartial() throws IOException {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DataInputStream inputStream = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        DefaultRecord.readPartiallyFrom((DataInput)inputStream, (byte[])this.skipArray, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=StringIndexOutOfBoundsException.class)
    public void testInvalidHeaderKey() {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)105, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DefaultRecord.readFrom((ByteBuffer)buf, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidHeaderKeyPartial() throws IOException {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)105, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DataInputStream inputStream = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        DefaultRecord.readPartiallyFrom((DataInput)inputStream, (byte[])this.skipArray, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testNullHeaderKey() {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DefaultRecord.readFrom((ByteBuffer)buf, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testNullHeaderKeyPartial() throws IOException {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DataInputStream inputStream = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        DefaultRecord.readPartiallyFrom((DataInput)inputStream, (byte[])this.skipArray, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidHeaderValue() {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)1, (ByteBuffer)buf);
        buf.put((byte)1);
        ByteUtils.writeVarint((int)105, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DefaultRecord.readFrom((ByteBuffer)buf, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidHeaderValuePartial() throws IOException {
        byte attributes = 0;
        long timestampDelta = 2L;
        int offsetDelta = 1;
        int sizeOfBodyInBytes = 100;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)timestampDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)offsetDelta, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)-1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)1, (ByteBuffer)buf);
        ByteUtils.writeVarint((int)1, (ByteBuffer)buf);
        buf.put((byte)1);
        ByteUtils.writeVarint((int)105, (ByteBuffer)buf);
        buf.position(buf.limit());
        buf.flip();
        DataInputStream inputStream = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        DefaultRecord.readPartiallyFrom((DataInput)inputStream, (byte[])this.skipArray, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testUnderflowReadingTimestamp() {
        byte attributes = 0;
        int sizeOfBodyInBytes = 1;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes));
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        buf.flip();
        DefaultRecord.readFrom((ByteBuffer)buf, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testUnderflowReadingVarlong() {
        byte attributes = 0;
        int sizeOfBodyInBytes = 2;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes) + 1);
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        buf.put(attributes);
        ByteUtils.writeVarlong((long)156L, (ByteBuffer)buf);
        buf.position(buf.limit() - 1);
        buf.flip();
        DefaultRecord.readFrom((ByteBuffer)buf, (long)0L, (long)0L, (int)-1, null);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidVarlong() {
        byte attributes = 0;
        int sizeOfBodyInBytes = 11;
        ByteBuffer buf = ByteBuffer.allocate(sizeOfBodyInBytes + ByteUtils.sizeOfVarint((int)sizeOfBodyInBytes) + 1);
        ByteUtils.writeVarint((int)sizeOfBodyInBytes, (ByteBuffer)buf);
        int recordStartPosition = buf.position();
        buf.put(attributes);
        ByteUtils.writeVarlong((long)Long.MAX_VALUE, (ByteBuffer)buf);
        buf.put(recordStartPosition + 10, (byte)-128);
        buf.flip();
        DefaultRecord.readFrom((ByteBuffer)buf, (long)0L, (long)0L, (int)-1, null);
    }

    @Test
    public void testSerdeNoSequence() throws IOException {
        ByteBuffer key = ByteBuffer.wrap("hi".getBytes());
        ByteBuffer value = ByteBuffer.wrap("there".getBytes());
        long baseOffset = 37L;
        int offsetDelta = 10;
        long baseTimestamp = System.currentTimeMillis();
        long timestampDelta = 323L;
        ByteBufferOutputStream out = new ByteBufferOutputStream(1024);
        DefaultRecord.writeTo((DataOutputStream)new DataOutputStream((OutputStream)out), (int)offsetDelta, (long)timestampDelta, (ByteBuffer)key, (ByteBuffer)value, (Header[])new Header[0]);
        ByteBuffer buffer = out.buffer();
        buffer.flip();
        DefaultRecord record = DefaultRecord.readFrom((ByteBuffer)buffer, (long)baseOffset, (long)baseTimestamp, (int)-1, null);
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)-1L, (long)record.sequence());
    }
}

