/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.ByteBufferLogInputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;

public class ByteBufferLogInputStreamTest {
    @Test
    public void iteratorIgnoresIncompleteEntries() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(15L, "a".getBytes(), "1".getBytes());
        builder.append(20L, "b".getBytes(), "2".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)2L);
        builder.append(30L, "c".getBytes(), "3".getBytes());
        builder.append(40L, "d".getBytes(), "4".getBytes());
        builder.close();
        buffer.flip();
        buffer.limit(buffer.limit() - 5);
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        Iterator iterator = records.batches().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        MutableRecordBatch first = (MutableRecordBatch)iterator.next();
        Assert.assertEquals((long)1L, (long)first.lastOffset());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test(expected=CorruptRecordException.class)
    public void iteratorRaisesOnTooSmallRecords() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(15L, "a".getBytes(), "1".getBytes());
        builder.append(20L, "b".getBytes(), "2".getBytes());
        builder.close();
        int position = buffer.position();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)2L);
        builder.append(30L, "c".getBytes(), "3".getBytes());
        builder.append(40L, "d".getBytes(), "4".getBytes());
        builder.close();
        buffer.flip();
        buffer.putInt(position + 8, 9);
        ByteBufferLogInputStream logInputStream = new ByteBufferLogInputStream(buffer, Integer.MAX_VALUE);
        Assert.assertNotNull((Object)logInputStream.nextBatch());
        logInputStream.nextBatch();
    }

    @Test(expected=CorruptRecordException.class)
    public void iteratorRaisesOnInvalidMagic() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(15L, "a".getBytes(), "1".getBytes());
        builder.append(20L, "b".getBytes(), "2".getBytes());
        builder.close();
        int position = buffer.position();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)2L);
        builder.append(30L, "c".getBytes(), "3".getBytes());
        builder.append(40L, "d".getBytes(), "4".getBytes());
        builder.close();
        buffer.flip();
        buffer.put(position + 16, (byte)37);
        ByteBufferLogInputStream logInputStream = new ByteBufferLogInputStream(buffer, Integer.MAX_VALUE);
        Assert.assertNotNull((Object)logInputStream.nextBatch());
        logInputStream.nextBatch();
    }

    @Test(expected=CorruptRecordException.class)
    public void iteratorRaisesOnTooLargeRecords() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(15L, "a".getBytes(), "1".getBytes());
        builder.append(20L, "b".getBytes(), "2".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)2L);
        builder.append(30L, "c".getBytes(), "3".getBytes());
        builder.append(40L, "d".getBytes(), "4".getBytes());
        builder.close();
        buffer.flip();
        ByteBufferLogInputStream logInputStream = new ByteBufferLogInputStream(buffer, 25);
        Assert.assertNotNull((Object)logInputStream.nextBatch());
        logInputStream.nextBatch();
    }
}

