/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.record.AbstractLegacyRecordBatch;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class AbstractLegacyRecordBatchTest {
    @Test
    public void testSetLastOffsetCompressed() {
        SimpleRecord[] simpleRecords = new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())};
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
        long lastOffset = 500L;
        long firstOffset = lastOffset - (long)simpleRecords.length + 1L;
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setLastOffset(lastOffset);
        Assert.assertEquals((long)lastOffset, (long)batch.lastOffset());
        Assert.assertEquals((long)firstOffset, (long)batch.baseOffset());
        Assert.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assert.assertEquals((long)1L, (long)recordBatches.size());
        Assert.assertEquals((long)lastOffset, (long)((MutableRecordBatch)recordBatches.get(0)).lastOffset());
        long offset = firstOffset;
        for (Record record : records.records()) {
            Assert.assertEquals((long)offset++, (long)record.offset());
        }
    }

    @Test
    public void testIterateCompressedRecordWithWrapperOffsetZero() {
        for (byte magic : Arrays.asList((byte)0, (byte)1)) {
            SimpleRecord[] simpleRecords = new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())};
            MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
            AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
            batch.setLastOffset(0L);
            long offset = 0L;
            for (Record record : batch) {
                Assert.assertEquals((long)offset++, (long)record.offset());
            }
        }
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidWrapperOffsetV1() {
        SimpleRecord[] simpleRecords = new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())};
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setLastOffset(1L);
        batch.iterator();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetNoTimestampTypeNotAllowed() {
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setMaxTimestamp(TimestampType.NO_TIMESTAMP_TYPE, -1L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetLogAppendTimeNotAllowedV0() {
        MemoryRecords records = MemoryRecords.withRecords((byte)0, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        long logAppendTime = 15L;
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setMaxTimestamp(TimestampType.LOG_APPEND_TIME, logAppendTime);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetCreateTimeNotAllowedV0() {
        MemoryRecords records = MemoryRecords.withRecords((byte)0, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        long createTime = 15L;
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setMaxTimestamp(TimestampType.CREATE_TIME, createTime);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetPartitionLeaderEpochNotAllowedV0() {
        MemoryRecords records = MemoryRecords.withRecords((byte)0, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setPartitionLeaderEpoch(15);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetPartitionLeaderEpochNotAllowedV1() {
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setPartitionLeaderEpoch(15);
    }

    @Test
    public void testSetLogAppendTimeV1() {
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        long logAppendTime = 15L;
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setMaxTimestamp(TimestampType.LOG_APPEND_TIME, logAppendTime);
        Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)logAppendTime, (long)batch.maxTimestamp());
        Assert.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assert.assertEquals((long)1L, (long)recordBatches.size());
        Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)((MutableRecordBatch)recordBatches.get(0)).timestampType());
        Assert.assertEquals((long)logAppendTime, (long)((MutableRecordBatch)recordBatches.get(0)).maxTimestamp());
        for (Record record : records.records()) {
            Assert.assertEquals((long)logAppendTime, (long)record.timestamp());
        }
    }

    @Test
    public void testSetCreateTimeV1() {
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        long createTime = 15L;
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setMaxTimestamp(TimestampType.CREATE_TIME, createTime);
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)createTime, (long)batch.maxTimestamp());
        Assert.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assert.assertEquals((long)1L, (long)recordBatches.size());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)((MutableRecordBatch)recordBatches.get(0)).timestampType());
        Assert.assertEquals((long)createTime, (long)((MutableRecordBatch)recordBatches.get(0)).maxTimestamp());
        long expectedTimestamp = 1L;
        for (Record record : records.records()) {
            Assert.assertEquals((long)expectedTimestamp++, (long)record.timestamp());
        }
    }

    @Test
    public void testZStdCompressionTypeWithV0OrV1() {
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch;
        MemoryRecords records;
        SimpleRecord[] simpleRecords = new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())};
        try {
            records = MemoryRecords.withRecords((byte)0, (long)0L, (CompressionType)CompressionType.ZSTD, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
            batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
            batch.setLastOffset(1L);
            batch.iterator();
            Assert.fail((String)"Can't reach here");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"ZStandard compression is not supported for magic 0", (Object)e.getMessage());
        }
        try {
            records = MemoryRecords.withRecords((byte)1, (long)0L, (CompressionType)CompressionType.ZSTD, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
            batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
            batch.setLastOffset(1L);
            batch.iterator();
            Assert.fail((String)"Can't reach here");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"ZStandard compression is not supported for magic 1", (Object)e.getMessage());
        }
    }
}

