/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class MetadataRequestData
implements ApiMessage {
    private List<MetadataRequestTopic> topics = new ArrayList<MetadataRequestTopic>();
    private boolean allowAutoTopicCreation;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(MetadataRequestTopic.SCHEMA_0), "The topics to fetch metadata for."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;

    public MetadataRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public MetadataRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public MetadataRequestData() {
        this.allowAutoTopicCreation = true;
    }

    @Override
    public short apiKey() {
        return 3;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 7;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics = null;
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new MetadataRequestTopic(readable, version));
            }
        }
        this.allowAutoTopicCreation = version >= 4 ? readable.readByte() != 0 : true;
    }

    @Override
    public void write(Writable writable, short version) {
        if (this.topics == null) {
            writable.writeInt(-1);
        } else {
            writable.writeInt(this.topics.size());
            for (MetadataRequestTopic element : this.topics) {
                element.write(writable, version);
            }
        }
        if (version >= 4) {
            writable.writeByte(this.allowAutoTopicCreation ? (byte)1 : 0);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("topics");
        if (nestedObjects == null) {
            this.topics = null;
        } else {
            this.topics = new ArrayList<MetadataRequestTopic>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.topics.add(new MetadataRequestTopic((Struct)nestedObject, version));
            }
        }
        this.allowAutoTopicCreation = version >= 4 ? struct.getBoolean("allow_auto_topic_creation") : true;
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (this.topics == null) {
            struct.set("topics", null);
        } else {
            Struct[] nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (MetadataRequestTopic element : this.topics) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("topics", (Object)nestedObjects);
        }
        if (version >= 4) {
            struct.set("allow_auto_topic_creation", (Object)this.allowAutoTopicCreation);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        if (this.topics == null) {
            size += 4;
        } else {
            size += 4;
            for (MetadataRequestTopic element : this.topics) {
                size += element.size(version);
            }
        }
        if (version >= 4) {
            ++size;
        } else if (!this.allowAutoTopicCreation) {
            throw new UnsupportedVersionException("Attempted to write a non-default allowAutoTopicCreation at version " + version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetadataRequestData)) {
            return false;
        }
        MetadataRequestData other = (MetadataRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return this.allowAutoTopicCreation == other.allowAutoTopicCreation;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.allowAutoTopicCreation ? 1231 : 1237);
        return hashCode;
    }

    public String toString() {
        return "MetadataRequestData(topics=" + (this.topics == null ? "null" : MessageUtil.deepToString(this.topics.iterator())) + ", allowAutoTopicCreation=" + (this.allowAutoTopicCreation ? "true" : "false") + ")";
    }

    public List<MetadataRequestTopic> topics() {
        return this.topics;
    }

    public boolean allowAutoTopicCreation() {
        return this.allowAutoTopicCreation;
    }

    public MetadataRequestData setTopics(List<MetadataRequestTopic> v) {
        this.topics = v;
        return this;
    }

    public MetadataRequestData setAllowAutoTopicCreation(boolean v) {
        this.allowAutoTopicCreation = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("topics", ArrayOf.nullable(MetadataRequestTopic.SCHEMA_0), "The topics to fetch metadata for.")));
        SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = new Schema(new Field("topics", ArrayOf.nullable(MetadataRequestTopic.SCHEMA_0), "The topics to fetch metadata for."), new Field("allow_auto_topic_creation", Type.BOOLEAN, "If this is true, the broker may auto-create topics that we requested which do not already exist, if it is configured to do so."))));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class MetadataRequestTopic
    implements Message {
        private String name;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public MetadataRequestTopic(Readable readable, short version) {
            this.read(readable, version);
        }

        public MetadataRequestTopic(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public MetadataRequestTopic() {
            this.name = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            return size += MessageUtil.serializedUtf8Length(this.name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataRequestTopic)) {
                return false;
            }
            MetadataRequestTopic other = (MetadataRequestTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "MetadataRequestTopic(name='" + this.name + "')";
        }

        public String name() {
            return this.name;
        }

        public MetadataRequestTopic setName(String v) {
            this.name = v;
            return this;
        }

        static {
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."))))))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

