/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.auth;

import java.net.InetAddress;
import java.security.Principal;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.security.kerberos.KerberosName;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Test;

public class DefaultKafkaPrincipalBuilderTest
extends EasyMockSupport {
    @Test
    public void testUseOldPrincipalBuilderForPlaintextIfProvided() throws Exception {
        TransportLayer transportLayer = (TransportLayer)this.mock(TransportLayer.class);
        Authenticator authenticator = (Authenticator)this.mock(Authenticator.class);
        PrincipalBuilder oldPrincipalBuilder = (PrincipalBuilder)this.mock(PrincipalBuilder.class);
        EasyMock.expect((Object)oldPrincipalBuilder.buildPrincipal(transportLayer, authenticator)).andReturn((Object)new DummyPrincipal("foo"));
        oldPrincipalBuilder.close();
        EasyMock.expectLastCall();
        this.replayAll();
        DefaultKafkaPrincipalBuilder builder = DefaultKafkaPrincipalBuilder.fromOldPrincipalBuilder((Authenticator)authenticator, (TransportLayer)transportLayer, (PrincipalBuilder)oldPrincipalBuilder, null);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new PlaintextAuthenticationContext(InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name()));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)"foo", (Object)principal.getName());
        builder.close();
        this.verifyAll();
    }

    @Test
    public void testReturnAnonymousPrincipalForPlaintext() throws Exception {
        DefaultKafkaPrincipalBuilder builder = new DefaultKafkaPrincipalBuilder(null);
        Assert.assertEquals((Object)KafkaPrincipal.ANONYMOUS, (Object)builder.build((AuthenticationContext)new PlaintextAuthenticationContext(InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name())));
        builder.close();
    }

    @Test
    public void testUseOldPrincipalBuilderForSslIfProvided() throws Exception {
        TransportLayer transportLayer = (TransportLayer)this.mock(TransportLayer.class);
        Authenticator authenticator = (Authenticator)this.mock(Authenticator.class);
        PrincipalBuilder oldPrincipalBuilder = (PrincipalBuilder)this.mock(PrincipalBuilder.class);
        SSLSession session = (SSLSession)this.mock(SSLSession.class);
        EasyMock.expect((Object)oldPrincipalBuilder.buildPrincipal(transportLayer, authenticator)).andReturn((Object)new DummyPrincipal("foo"));
        oldPrincipalBuilder.close();
        EasyMock.expectLastCall();
        this.replayAll();
        DefaultKafkaPrincipalBuilder builder = DefaultKafkaPrincipalBuilder.fromOldPrincipalBuilder((Authenticator)authenticator, (TransportLayer)transportLayer, (PrincipalBuilder)oldPrincipalBuilder, null);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SslAuthenticationContext(session, InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name()));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)"foo", (Object)principal.getName());
        builder.close();
        this.verifyAll();
    }

    @Test
    public void testUseSessionPeerPrincipalForSsl() throws Exception {
        SSLSession session = (SSLSession)this.mock(SSLSession.class);
        EasyMock.expect((Object)session.getPeerPrincipal()).andReturn((Object)new DummyPrincipal("foo"));
        this.replayAll();
        DefaultKafkaPrincipalBuilder builder = new DefaultKafkaPrincipalBuilder(null);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SslAuthenticationContext(session, InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name()));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)"foo", (Object)principal.getName());
        builder.close();
        this.verifyAll();
    }

    @Test
    public void testPrincipalBuilderScram() throws Exception {
        SaslServer server = (SaslServer)this.mock(SaslServer.class);
        EasyMock.expect((Object)server.getMechanismName()).andReturn((Object)ScramMechanism.SCRAM_SHA_256.mechanismName());
        EasyMock.expect((Object)server.getAuthorizationID()).andReturn((Object)"foo");
        this.replayAll();
        DefaultKafkaPrincipalBuilder builder = new DefaultKafkaPrincipalBuilder(null);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SaslAuthenticationContext(server, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLocalHost(), SecurityProtocol.SASL_PLAINTEXT.name()));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)"foo", (Object)principal.getName());
        builder.close();
        this.verifyAll();
    }

    @Test
    public void testPrincipalBuilderGssapi() throws Exception {
        SaslServer server = (SaslServer)this.mock(SaslServer.class);
        KerberosShortNamer kerberosShortNamer = (KerberosShortNamer)this.mock(KerberosShortNamer.class);
        EasyMock.expect((Object)server.getMechanismName()).andReturn((Object)"GSSAPI");
        EasyMock.expect((Object)server.getAuthorizationID()).andReturn((Object)"foo/host@REALM.COM");
        EasyMock.expect((Object)kerberosShortNamer.shortName((KerberosName)EasyMock.anyObject(KerberosName.class))).andReturn((Object)"foo");
        this.replayAll();
        DefaultKafkaPrincipalBuilder builder = new DefaultKafkaPrincipalBuilder(kerberosShortNamer);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SaslAuthenticationContext(server, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLocalHost(), SecurityProtocol.SASL_PLAINTEXT.name()));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)"foo", (Object)principal.getName());
        builder.close();
        this.verifyAll();
    }

    private static class DummyPrincipal
    implements Principal {
        private final String name;

        private DummyPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

