/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.shex.expressions.ValueSetItem;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.util.NodeUtils;

public class ValueSetRange {
    public ValueSetItem item;
    public ArrayList<ValueSetItem> exclusions;

    public ValueSetRange(String iriStr, String lang, Node literal, boolean isStem) {
        this.item = new ValueSetItem(iriStr, lang, literal, isStem);
        this.exclusions = new ArrayList();
    }

    public String type() {
        if (this.item.iriStr != null) {
            return "IRI";
        }
        if (this.item.langStr != null) {
            return "Language";
        }
        if (this.item.literal != null) {
            return "Literal";
        }
        return "unknown";
    }

    public boolean included(Node data) {
        return ValueSetRange.contains(this.item, data);
    }

    public boolean excluded(Node data) {
        for (ValueSetItem ex : this.exclusions) {
            if (!ValueSetRange.contains(ex, data)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.exclusions, this.item);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueSetRange other = (ValueSetRange)obj;
        return Objects.equals(this.exclusions, other.exclusions) && Objects.equals(this.item, other.item);
    }

    private static boolean contains(ValueSetItem item, Node node) {
        if (!item.isStem) {
            return ValueSetRange.matchExact(item, node);
        }
        return ValueSetRange.matchStem(item, node);
    }

    private static boolean matchExact(ValueSetItem item, Node node) {
        if (item.langStr != null) {
            if (!node.isLiteral()) {
                return false;
            }
            String lang = node.getLiteralLanguage();
            return item.langStr.equalsIgnoreCase(lang);
        }
        if (item.literal != null) {
            return item.literal.equals((Object)node);
        }
        if (item.iriStr != null) {
            if (!node.isURI()) {
                return false;
            }
            return item.iriStr.equals(node.getURI());
        }
        return true;
    }

    private static boolean matchStem(ValueSetItem item, Node node) {
        if (item.langStr != null) {
            if (!NodeUtils.hasLang((Node)node)) {
                return false;
            }
            String lang = node.getLiteralLanguage();
            String pattern = item.langStr.isEmpty() ? "*" : item.langStr;
            return NodeFunctions.langMatches((String)lang, (String)pattern);
        }
        if (item.literal != null) {
            if (!node.isLiteral()) {
                return false;
            }
            String sData = node.getLiteralLexicalForm();
            String sSchema = NodeFunctions.str((Node)item.literal);
            return sData.startsWith(sSchema);
        }
        if (item.iriStr != null) {
            if (!node.isURI()) {
                return false;
            }
            return node.getURI().startsWith(item.iriStr);
        }
        return false;
    }
}

