/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.lib.ActionKeyValue;
import org.openjena.atlas.lib.Pair;

public class PrefixMap {
    private final Map<String, IRI> prefixes = new HashMap<String, IRI>();
    private final Map<String, IRI> prefixes2 = Collections.unmodifiableMap(this.prefixes);

    public PrefixMap() {
    }

    public PrefixMap(PrefixMap other) {
        this.prefixes.putAll(other.prefixes);
    }

    public Map<String, IRI> getMapping() {
        return this.prefixes2;
    }

    public Map<String, IRI> getMappingCopy() {
        return new HashMap<String, IRI>(this.prefixes);
    }

    public Map<String, String> getMappingCopyStr() {
        final HashMap smap = new HashMap();
        ActionKeyValue<String, IRI> action = new ActionKeyValue<String, IRI>(){

            @Override
            public void apply(String key, IRI value) {
                String str2 = value.toString();
                smap.put(key, str2);
            }
        };
        Iter.apply(this.getMapping(), action);
        return Collections.unmodifiableMap(smap);
    }

    public void add(String prefix, String iriString) {
        prefix = PrefixMap.canonicalPrefix(prefix);
        IRI iri2 = IRIFactory.iriImplementation().create(iriString);
        this.prefixes.put(prefix, iri2);
    }

    public void add(String prefix, IRI iri2) {
        prefix = PrefixMap.canonicalPrefix(prefix);
        this.prefixes.put(prefix, iri2);
    }

    public void putAll(PrefixMap pmap) {
        this.prefixes.putAll(pmap.prefixes);
    }

    public void delete(String prefix) {
        prefix = PrefixMap.canonicalPrefix(prefix);
        this.prefixes.remove(prefix);
    }

    public boolean contains(String prefix) {
        prefix = PrefixMap.canonicalPrefix(prefix);
        return this._contains(prefix);
    }

    protected boolean _contains(String prefix) {
        return this.prefixes.containsKey(prefix);
    }

    public String abbreviate(String uriStr) {
        for (Map.Entry<String, IRI> e2 : this.prefixes.entrySet()) {
            String ln;
            String prefix = e2.getValue().toString();
            if (!uriStr.startsWith(prefix) || !PrefixMap.strSafeFor(ln = uriStr.substring(prefix.length()), '/') || !PrefixMap.strSafeFor(ln, '#') || !PrefixMap.strSafeFor(ln, ':')) continue;
            return e2.getKey() + ":" + ln;
        }
        return null;
    }

    private static boolean strSafeFor(String str2, char ch) {
        return str2.indexOf(ch) == -1;
    }

    public Pair<String, String> abbrev(String uriStr) {
        for (Map.Entry<String, IRI> e2 : this.prefixes.entrySet()) {
            String uriForPrefix = e2.getValue().toString();
            if (!uriStr.startsWith(uriForPrefix)) continue;
            return Pair.create(e2.getKey(), uriStr.substring(uriForPrefix.length()));
        }
        return null;
    }

    public String expand(String prefixedName) {
        int i = prefixedName.indexOf(58);
        if (i < 0) {
            return null;
        }
        return this.expand(prefixedName.substring(0, i), prefixedName.substring(i + 1));
    }

    public String expand(String prefix, String localName) {
        IRI x = this.prefixes.get(prefix = PrefixMap.canonicalPrefix(prefix));
        if (x == null) {
            return null;
        }
        return x.toString() + localName;
    }

    protected static String canonicalPrefix(String prefix) {
        if (prefix.endsWith(":")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (Map.Entry<String, IRI> e2 : this.prefixes.entrySet()) {
            String prefix = e2.getKey();
            IRI iri2 = e2.getValue();
            if (first) {
                first = false;
            } else {
                sb.append(" ,");
            }
            sb.append(prefix);
            sb.append(":=");
            sb.append(iri2.toString());
        }
        sb.append(" }");
        return sb.toString();
    }
}

