/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import java.util.HashMap;
import java.util.Map;
import org.openjena.riot.ContentType;
import org.openjena.riot.Lang;

public class WebContent {
    public static final String contentTypeN3 = "text/rdf+n3";
    public static final String contentTypeN3Alt1 = "application/n3";
    public static final String contentTypeN3Alt2 = "text/n3";
    public static final String contentTypeTurtle = "text/turtle";
    public static final String contentTypeTurtleAlt1 = "application/turtle";
    public static final String contentTypeTurtleAlt2 = "application/x-turtle";
    @Deprecated
    public static final String contentTypeTurtle1 = "application/turtle";
    @Deprecated
    public static final String contentTypeTurtle2 = "text/turtle";
    @Deprecated
    public static final String contentTypeTurtle3 = "application/x-turtle";
    public static final String contentTypeRDFXML = "application/rdf+xml";
    public static final String contentTypeRDFJSON = "application/rdf+json";
    public static final String contentTypeTextPlain = "text/plain";
    public static final String contentTypeNTriples = "text/plain";
    public static final String contentTypeNTriplesAlt = "application/n-triples";
    public static final String contentTypeXML = "application/xml";
    public static final String contentTypeTriG = "application/trig";
    public static final String contentTypeNQuads = "text/nquads";
    public static final String contentTypeTriGAlt = "application/x-trig";
    public static final String contentTypeNQuadsAlt = "text/x-nquads";
    public static final String contentTypeTriX = "application/trix+xml";
    public static final String contentTypeOctets = "application/octet-stream";
    public static final String contentTypeRdfJson = "application/rdf+json";
    public static final String contentTypeResultsXML = "application/sparql-results+xml";
    public static final String contentTypeResultsJSON = "application/sparql-results+json";
    public static final String contentTypeJSON = "application/json";
    public static final String contentTypeResultsBIO = "application/sparql-results+bio";
    public static final String contentTypeSPARQLQuery = "application/sparql-query";
    public static final String contentTypeSPARQLUpdate = "application/sparql-update";
    public static final String contentTypeForm = "application/x-www-form-urlencoded";
    public static final String contentTypeTextCSV = "text/csv";
    public static final String contentTypeTextTSV = "text/tab-separated-values";
    public static final String contentTypeSSE = "text/sse";
    public static final String charsetUTF8 = "utf-8";
    public static final String charsetASCII = "ascii";
    public static final ContentType ctN3 = ContentType.createConst("text/rdf+n3", "utf-8");
    public static final String langRDFXML = "RDF/XML";
    public static final String langRDFXMLAbbrev = "RDF/XML-ABBREV";
    public static final String langNTriple = "N-TRIPLE";
    public static final String langNTriples = "N-TRIPLES";
    public static final String langN3 = "N3";
    public static final String langTurtle = "TURTLE";
    public static final String langTTL = "TTL";
    public static final String langRdfJson = "RDF/JSON";
    public static final String langNQuads = "NQUADS";
    public static final String langTriG = "TRIG";
    public static final String encodingUTF8 = "utf-8";
    private static Map<String, Lang> mapContentTypeToLang = new HashMap<String, Lang>();
    private static Map<Lang, String> mapLangToContentType;

    public static String contentTypeCanonical(String contentType) {
        Lang lang = WebContent.contentTypeToLang(contentType);
        if (lang == null) {
            return null;
        }
        return mapLangToContentType.get((Object)lang);
    }

    public static Lang contentTypeToLang(String contentType) {
        return mapContentTypeToLang.get(contentType);
    }

    public static String mapLangToContentType(Lang lang) {
        return mapLangToContentType.get((Object)lang);
    }

    public static String getCharsetForContentType(String contentType) {
        ContentType ct = ContentType.parse(contentType);
        if (ct.getCharset() != null) {
            return ct.getCharset();
        }
        if (ct.getDftCharset() != null) {
            return ct.getDftCharset();
        }
        String mt = ct.getContentType();
        if ("text/plain".equals(mt)) {
            return charsetASCII;
        }
        if (contentTypeNTriplesAlt.equals(mt)) {
            return charsetASCII;
        }
        if (contentTypeNQuads.equals(mt)) {
            return charsetASCII;
        }
        if (contentTypeNQuadsAlt.equals(mt)) {
            return charsetASCII;
        }
        return "utf-8";
    }

    static {
        mapContentTypeToLang.put(contentTypeRDFXML, Lang.RDFXML);
        mapContentTypeToLang.put(contentTypeN3, Lang.N3);
        mapContentTypeToLang.put(contentTypeN3Alt1, Lang.N3);
        mapContentTypeToLang.put(contentTypeN3Alt2, Lang.N3);
        mapContentTypeToLang.put("text/turtle", Lang.TURTLE);
        mapContentTypeToLang.put("application/turtle", Lang.TURTLE);
        mapContentTypeToLang.put("application/x-turtle", Lang.TURTLE);
        mapContentTypeToLang.put("text/plain", Lang.NTRIPLES);
        mapContentTypeToLang.put(contentTypeNTriplesAlt, Lang.NTRIPLES);
        mapContentTypeToLang.put("application/rdf+json", Lang.RDFJSON);
        mapContentTypeToLang.put(contentTypeNQuads, Lang.NQUADS);
        mapContentTypeToLang.put(contentTypeNQuadsAlt, Lang.NQUADS);
        mapContentTypeToLang.put(contentTypeTriG, Lang.TRIG);
        mapContentTypeToLang.put(contentTypeTriGAlt, Lang.TRIG);
        mapLangToContentType = new HashMap<Lang, String>();
        mapLangToContentType.put(Lang.N3, contentTypeN3);
        mapLangToContentType.put(Lang.TURTLE, "text/turtle");
        mapLangToContentType.put(Lang.NTRIPLES, "text/plain");
        mapLangToContentType.put(Lang.RDFXML, contentTypeRDFXML);
        mapLangToContentType.put(Lang.RDFJSON, "application/rdf+json");
        mapLangToContentType.put(Lang.NQUADS, contentTypeNQuads);
        mapLangToContentType.put(Lang.TRIG, contentTypeTriG);
    }
}

