/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.table.TableData;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.resultset.ResultSetCompare;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ElementData
extends Element {
    private List<Var> vars = new ArrayList<Var>();
    private List<Binding> rows = new ArrayList<Binding>();

    public Table getTable() {
        return new TableData(this.vars, this.rows);
    }

    public List<Var> getVars() {
        return this.vars;
    }

    public List<Binding> getRows() {
        return this.rows;
    }

    public void add(Var var) {
        if (!this.vars.contains((Object)var)) {
            this.vars.add(var);
        }
    }

    public void add(Binding binding) {
        Iterator<Var> iter = binding.vars();
        while (iter.hasNext()) {
            Var v = iter.next();
            if (this.vars.contains((Object)v)) continue;
            throw new ARQException("Variable " + (Object)((Object)v) + " not already declared for ElementData");
        }
        this.rows.add(binding);
    }

    @Override
    public boolean equalTo(Element el2, NodeIsomorphismMap isoMap) {
        if (!(el2 instanceof ElementData)) {
            return false;
        }
        ElementData f2 = (ElementData)el2;
        if (!((Object)this.vars).equals(f2.vars)) {
            return false;
        }
        return ResultSetCompare.equalsByTest(this.rows, f2.rows, new ResultSetCompare.BNodeIso(NodeUtils.sameTerm));
    }

    @Override
    public int hashCode() {
        return ((Object)this.vars).hashCode() ^ ((Object)this.rows).hashCode();
    }

    @Override
    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

