/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.resultset.TSVInputIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.openjena.atlas.io.IO;

public class TSVInput {
    static Pattern pattern = Pattern.compile("\t");

    public static ResultSet fromTSV(InputStream in) {
        BufferedReader reader = IO.asBufferedUTF8(in);
        ArrayList<Var> vars = new ArrayList<Var>();
        ArrayList<String> varNames = new ArrayList<String>();
        String str2 = null;
        try {
            str2 = reader.readLine();
            if (str2 == null) {
                throw new ARQException("TSV Results malformed - input is empty (no header row)");
            }
            if (!str2.isEmpty()) {
                String[] tokens2;
                for (String token : tokens2 = pattern.split(str2, -1)) {
                    if (token.startsWith("?")) {
                        token = token.substring(1);
                    }
                    Var var = Var.alloc(token);
                    vars.add(var);
                    varNames.add(var.getName());
                }
            }
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
        return new ResultSetStream(varNames, null, new TSVInputIterator(reader, vars));
    }
}

