/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchFilter;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.mem.GraphMemBulkUpdateHandler;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.util.Set;

public class SmallGraphMem
extends GraphMemBase {
    protected Set<Triple> triples = CollectionFactory.createHashedSet();

    public SmallGraphMem() {
        this(ReificationStyle.Minimal);
    }

    public SmallGraphMem(ReificationStyle style) {
        super(style);
    }

    protected TripleStore createTripleStore() {
        return null;
    }

    public void performAdd(Triple t) {
        if (!this.getReifier().handledAdd(t)) {
            this.triples.add(t);
        }
    }

    public void performDelete(Triple t) {
        if (!this.getReifier().handledRemove(t)) {
            this.triples.remove(t);
        }
    }

    public int graphBaseSize() {
        return this.triples.size();
    }

    public boolean graphBaseContains(Triple t) {
        return this.isSafeForEquality(t) ? this.triples.contains(t) : this.containsByFind(t);
    }

    protected void destroy() {
        this.triples = null;
    }

    public void clear() {
        this.triples.clear();
        ((SimpleReifier)this.getReifier()).clear();
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new GraphMemBulkUpdateHandler((GraphWithPerform)this);
        }
        return this.bulkHandler;
    }

    public ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        return SimpleEventManager.notifyingRemove((Graph)this, this.triples.iterator()).filterKeep((Filter)new TripleMatchFilter(m.asTriple()));
    }
}

