/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.main.JoinClassifier;
import com.hp.hpl.jena.sparql.engine.main.VarFinder;
import java.util.Set;
import org.openjena.atlas.lib.SetUtils;

public class LeftJoinClassifier {
    public static boolean isLinear(OpLeftJoin op) {
        return LeftJoinClassifier.isLinear(op.getLeft(), op.getRight());
    }

    public static boolean isLinear(Op left, Op right) {
        left = JoinClassifier.effectiveOp(left);
        if ((right = JoinClassifier.effectiveOp(right)) instanceof OpModifier) {
            return false;
        }
        Set<Var> leftVars = OpVars.patternVars(left);
        VarFinder vf = new VarFinder(right);
        Set<Var> optRight = vf.getOpt();
        Set<Var> filterVarsRight = vf.getFilter();
        boolean b1 = SetUtils.intersectionP(leftVars, optRight);
        boolean b2 = SetUtils.intersectionP(leftVars, filterVarsRight);
        return !SetUtils.intersectionP(leftVars, optRight) && !SetUtils.intersectionP(leftVars, filterVarsRight);
    }

    public static Set<Var> nonLinearVars(OpLeftJoin op) {
        Op left = JoinClassifier.effectiveOp(op.getLeft());
        Op right = JoinClassifier.effectiveOp(op.getRight());
        Set<Var> leftVars = OpVars.patternVars(left);
        Set<Var> optRight = VarFinder.optDefined(right);
        return SetUtils.intersection(leftVars, optRight);
    }
}

