/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModDataset;
import arq.cmdline.ModDatasetGeneralAssembler;
import arq.cmdline.ModEngine;
import arq.cmdline.ModQueryIn;
import arq.cmdline.ModResultsOut;
import arq.cmdline.ModTime;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.mgt.Explain;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import com.hp.hpl.jena.sparql.util.QueryExecUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import org.openjena.atlas.io.IndentedWriter;

public class query
extends CmdARQ {
    private ArgDecl argRepeat = new ArgDecl(true, "repeat");
    private ArgDecl argExplain = new ArgDecl(false, "explain");
    private ArgDecl argOptimize = new ArgDecl(true, "opt", "optimize");
    protected int repeatCount = 1;
    protected int warmupCount = 0;
    protected boolean queryOptimization = true;
    protected ModTime modTime = new ModTime();
    protected ModQueryIn modQuery = new ModQueryIn();
    protected ModDataset modDataset = null;
    protected ModResultsOut modResults = new ModResultsOut();
    protected ModEngine modEngine = new ModEngine();
    protected long totalTime = 0L;

    public static void main(String ... argv) {
        new query(argv).mainRun();
    }

    public query(String[] argv) {
        super(argv);
        this.modDataset = this.setModDataset();
        super.addModule(this.modQuery);
        super.addModule(this.modResults);
        super.addModule(this.modDataset);
        super.addModule(this.modEngine);
        super.addModule(this.modTime);
        super.getUsage().startCategory("Control");
        super.add(this.argExplain, "--explain", "Explain and log query execution");
        super.add(this.argRepeat, "--repeat=N or N,M", "Do N times or N warmup and then M times (use for timing to overcome start up costs of Java)");
        super.add(this.argOptimize, "--optimize=", "Turn the query optimizer on or off (default: on");
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(this.argRepeat)) {
            String[] x = this.getValue(this.argRepeat).split(",");
            if (x.length == 1) {
                try {
                    this.repeatCount = Integer.parseInt(x[0]);
                }
                catch (NumberFormatException ex) {
                    throw new CmdException("Can't parse " + x[0] + " in arg " + this.getValue(this.argRepeat) + " as an integer");
                }
            }
            if (x.length == 2) {
                try {
                    this.warmupCount = Integer.parseInt(x[0]);
                }
                catch (NumberFormatException ex) {
                    throw new CmdException("Can't parse " + x[0] + " in arg " + this.getValue(this.argRepeat) + " as an integer");
                }
                try {
                    this.repeatCount = Integer.parseInt(x[1]);
                }
                catch (NumberFormatException ex) {
                    throw new CmdException("Can't parse " + x[1] + " in arg " + this.getValue(this.argRepeat) + " as an integer");
                }
            }
            throw new CmdException("Wrong format for repeat count: " + this.getValue(this.argRepeat));
        }
        if (this.isVerbose()) {
            ARQ.getContext().setTrue(ARQ.symLogExec);
        }
        if (this.hasArg(this.argExplain)) {
            ARQ.setExecutionLogging(Explain.InfoLevel.ALL);
        }
        if (this.hasArg(this.argOptimize)) {
            String x1 = this.getValue(this.argOptimize).toLowerCase();
            if (this.hasValueOfTrue(this.argOptimize) || x1.equals("on") || x1.equals("yes")) {
                this.queryOptimization = true;
            } else if (this.hasValueOfFalse(this.argOptimize) || x1.equals("off") || x1.equals("no")) {
                this.queryOptimization = false;
            } else {
                throw new CmdException("Optimization flag must be true/false/on/off/yes/no. Found: " + this.getValue(this.argOptimize));
            }
        }
    }

    protected ModDataset setModDataset() {
        return new ModDatasetGeneralAssembler();
    }

    @Override
    protected void exec() {
        int i;
        if (!this.queryOptimization) {
            ARQ.getContext().setFalse(ARQ.optimization);
        }
        if (this.cmdStrictMode) {
            ARQ.getContext().setFalse(ARQ.optimization);
        }
        for (i = 0; i < this.warmupCount; ++i) {
            this.queryExec(false, ResultsFormat.FMT_NONE);
        }
        for (i = 0; i < this.repeatCount; ++i) {
            this.queryExec(this.modTime.timingEnabled(), this.modResults.getResultsFormat());
        }
        if (this.modTime.timingEnabled() && this.repeatCount > 1) {
            long avg = this.totalTime / (long)this.repeatCount;
            String avgStr = this.modTime.timeStr(avg);
            System.err.println("Total time: " + this.modTime.timeStr(this.totalTime) + " sec for repeat count of " + this.repeatCount + " : average: " + avgStr);
        }
    }

    @Override
    protected String getCommandName() {
        return Utils.className(this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --data=<file> --query=<query>";
    }

    protected Dataset getDataset() {
        return this.modDataset.getDataset();
    }

    protected void queryExec(boolean timed, ResultsFormat fmt) {
        try {
            Query query2 = this.modQuery.getQuery();
            if (this.isVerbose()) {
                IndentedWriter out = new IndentedWriter(System.out, true);
                query2.serialize(out);
                out.flush();
                System.out.println();
            }
            Dataset dataset = this.getDataset();
            this.modTime.startTimer();
            QueryExecution qe = QueryExecutionFactory.create(query2, dataset);
            if (dataset == null && !query2.hasDatasetDescription()) {
                System.err.println("Dataset not specified in query nor provided on command line.");
                throw new TerminationException(1);
            }
            QueryExecUtils.executeQuery(query2, qe, fmt);
            long time = this.modTime.endTimer();
            if (timed) {
                this.totalTime += time;
                System.err.println("Time: " + this.modTime.timeStr(time) + " sec");
            }
            qe.close();
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
        }
        catch (ResultSetException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        catch (QueryException qEx) {
            throw new CmdException("Query Exeception", (Throwable)((Object)qEx));
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (CmdException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Exception", ex);
        }
    }
}

