/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.BufferingWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.Writer2;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.system.IRILib;

public class IO {
    public static final int EOF = -1;
    public static final int UNSET = -2;
    public static final String encodingUTF8 = "utf-8";
    public static final String encodingAscii = "ascii";
    private static Charset utf8 = null;
    private static Charset ascii = null;
    private static final int BUFFER_SIZE = 8192;

    public static InputStream openFile(String filename) {
        try {
            return IO.openFileEx(filename);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }

    public static InputStream openFileEx(String filename) throws IOException {
        if (filename == null || filename.equals("-")) {
            return System.in;
        }
        if (filename.startsWith("file:")) {
            filename = filename.substring("file:".length());
            filename = IRILib.decode(filename);
        }
        InputStream in = new FileInputStream(filename);
        if (filename.endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public static Reader openFileUTF8(String filename) {
        return IO.openFileReader(filename, utf8);
    }

    public static Reader openFileASCII(String filename) {
        return IO.openFileReader(filename, ascii);
    }

    private static Reader openFileReader(String filename, Charset charset) {
        InputStream in = IO.openFile(filename);
        return new InputStreamReader(in, charset);
    }

    public static Reader asUTF8(InputStream in) {
        return new InputStreamReader(in, utf8.newDecoder());
    }

    public static Reader asASCII(InputStream in) {
        return new InputStreamReader(in, ascii.newDecoder());
    }

    public static BufferedReader asBufferedUTF8(InputStream in) {
        return new BufferedReader(IO.asUTF8(in));
    }

    public static Writer asUTF8(OutputStream out) {
        return new OutputStreamWriter(out, utf8.newEncoder());
    }

    public static Writer asASCII(OutputStream out) {
        return new OutputStreamWriter(out, ascii.newEncoder());
    }

    public static Writer asBufferedUTF8(OutputStream out) {
        OutputStreamWriter w = new OutputStreamWriter(out, utf8.newEncoder());
        return new BufferingWriter(w);
    }

    public static AWriter wrap(Writer w) {
        return Writer2.wrap(w);
    }

    public static AWriter wrapUTF8(OutputStream out) {
        return IO.wrap(IO.asUTF8(out));
    }

    public static AWriter wrapASCII(OutputStream out) {
        return IO.wrap(IO.asASCII(out));
    }

    public static PrintWriter asPrintWriterUTF8(OutputStream out) {
        return new PrintWriter(IO.asUTF8(out));
    }

    public static void close(Closeable resource) {
        resource.close();
    }

    public static void closeSilent(Closeable resource) {
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(java.io.Closeable resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void closeSilent(java.io.Closeable resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(AWriter resource) {
        if (resource == null) {
            return;
        }
        resource.close();
    }

    public static void closeSilent(AWriter resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(IndentedWriter resource) {
        if (resource == null) {
            return;
        }
        resource.close();
    }

    public static void closeSilent(IndentedWriter resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void exception(IOException ex) {
        throw new AtlasException(ex);
    }

    public static void exception(String msg, IOException ex) {
        throw new AtlasException(msg, ex);
    }

    public static void flush(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void flush(Writer out) {
        if (out == null) {
            return;
        }
        try {
            out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void flush(AWriter out) {
        if (out == null) {
            return;
        }
        out.flush();
    }

    public static byte[] readWholeFile(InputStream in) {
        try {
            int l;
            ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
            byte[] buff = new byte[8192];
            while ((l = in.read(buff)) > 0) {
                out.write(buff, 0, l);
            }
            out.close();
            return out.toByteArray();
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }

    public static String readWholeFileAsUTF8(String filename) throws IOException {
        FileInputStream in = new FileInputStream(filename);
        return IO.readWholeFileAsUTF8(in);
    }

    public static String readWholeFileAsUTF8(InputStream in) throws IOException {
        Reader r = IO.asUTF8(in);
        return IO.readWholeFileAsUTF8(r);
    }

    private static String readWholeFileAsUTF8(Reader r) throws IOException {
        int l;
        StringWriter sw = new StringWriter(8192);
        char[] buff = new char[8192];
        while ((l = r.read(buff)) >= 0) {
            sw.write(buff, 0, l);
        }
        sw.close();
        return sw.toString();
    }

    public static String uniqueFilename(String directory, String base, String ext) {
        File d = new File(directory);
        if (!d.exists()) {
            throw new IllegalArgumentException("Not found: " + directory);
        }
        try {
            String fn0;
            String fn = fn0 = d.getCanonicalPath() + File.separator + base;
            int x = 1;
            while (true) {
                File f;
                if (ext != null) {
                    fn = fn + "." + ext;
                }
                if (!(f = new File(fn)).exists()) {
                    return fn;
                }
                fn = fn0 + "-" + x++;
            }
        }
        catch (IOException e2) {
            IO.exception(e2);
            return null;
        }
    }

    static {
        try {
            utf8 = Charset.forName(encodingUTF8);
            ascii = Charset.forName(encodingAscii);
        }
        catch (Throwable ex) {
            Log.fatal(FileUtils.class, "Failed to get charset", ex);
        }
    }
}

