/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.compose.Polyadic;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.graph.GraphWrapper;
import com.hp.hpl.jena.sparql.mgt.ARQMgt;
import com.hp.hpl.jena.sparql.mgt.SystemInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Sync;

public class SystemARQ {
    private static List<SystemInfo> versions = new ArrayList<SystemInfo>();

    public static void sync(Model model) {
        SystemARQ.sync(model.getGraph());
    }

    public static void sync(Graph graph) {
        SystemARQ.syncGraph(graph);
    }

    private static void syncGraph(Graph graph) {
        if (graph instanceof InfGraph) {
            SystemARQ.syncGraph(((InfGraph)graph).getRawGraph());
        } else if (graph instanceof Polyadic) {
            SystemARQ.syncGraph(((Polyadic)graph).getBaseGraph());
        } else if (graph instanceof GraphWrapper) {
            SystemARQ.syncGraph(((GraphWrapper)graph).get());
        } else {
            SystemARQ.syncObject(graph);
        }
    }

    public static void sync(Dataset dataset) {
        SystemARQ.sync(dataset.asDatasetGraph());
    }

    public static void sync(DatasetGraph dataset) {
        if (dataset instanceof Sync) {
            ((Sync)((Object)dataset)).sync();
            return;
        }
        SystemARQ.sync(dataset.getDefaultGraph());
        Iterator<Node> iter = Iter.iterator(dataset.listGraphNodes());
        while (iter.hasNext()) {
            Node n = iter.next();
            Graph g = dataset.getGraph(n);
            SystemARQ.sync(g);
        }
    }

    public static void syncObject(Object object) {
        if (object instanceof Sync) {
            ((Sync)object).sync();
        }
    }

    public static void registerSubSystem(SystemInfo systemInfo) {
        ARQMgt.register(systemInfo.getJmxPath() + ".system:type=SystemInfo", systemInfo);
        versions.add(systemInfo);
    }

    public static Iterator<SystemInfo> registeredSubsystems() {
        return versions.iterator();
    }
}

