/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.config;

import com.google.common.base.Function;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.FirstRegion;
import org.jclouds.packet.PacketApi;
import org.jclouds.packet.domain.Href;
import org.jclouds.packet.domain.options.ListOptions;
import org.jclouds.packet.functions.HrefToListOptions;
import org.jclouds.packet.handlers.PacketErrorHandler;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class PacketHttpApiModule
extends HttpApiModule<PacketApi> {
    protected void configure() {
        super.configure();
        this.bind(ImplicitLocationSupplier.class).to(FirstRegion.class).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<Function<Href, ListOptions>>(){}).to(HrefToListOptions.class);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(PacketErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(PacketErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(PacketErrorHandler.class);
    }
}

