// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"rpc"
)

var _ = rpc.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  TSOpenSessionResp openSession(TSOpenSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeSession(TSCloseSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeBatchStatement(TSExecuteBatchStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchResultsResp fetchResults(TSFetchResultsReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus cancelOperation(TSCancelOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeOperation(TSCloseOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSGetTimeZoneResp getTimeZone(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus setTimeZone(TSSetTimeZoneReq req)")
  fmt.Fprintln(os.Stderr, "  ServerProperties getProperties()")
  fmt.Fprintln(os.Stderr, "  TSStatus setStorageGroup(i64 sessionId, string storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus createTimeseries(TSCreateTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteTimeseries(i64 sessionId,  path)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteStorageGroups(i64 sessionId,  storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteData(TSDeleteDataReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  i64 requestStatementId(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := rpc.NewTSIServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "openSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "OpenSession requires 1 args")
      flag.Usage()
    }
    arg254 := flag.Arg(1)
    mbTrans255 := thrift.NewTMemoryBufferLen(len(arg254))
    defer mbTrans255.Close()
    _, err256 := mbTrans255.WriteString(arg254)
    if err256 != nil {
      Usage()
      return
    }
    factory257 := thrift.NewTJSONProtocolFactory()
    jsProt258 := factory257.GetProtocol(mbTrans255)
    argvalue0 := rpc.NewTSOpenSessionReq()
    err259 := argvalue0.Read(context.Background(), jsProt258)
    if err259 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.OpenSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseSession requires 1 args")
      flag.Usage()
    }
    arg260 := flag.Arg(1)
    mbTrans261 := thrift.NewTMemoryBufferLen(len(arg260))
    defer mbTrans261.Close()
    _, err262 := mbTrans261.WriteString(arg260)
    if err262 != nil {
      Usage()
      return
    }
    factory263 := thrift.NewTJSONProtocolFactory()
    jsProt264 := factory263.GetProtocol(mbTrans261)
    argvalue0 := rpc.NewTSCloseSessionReq()
    err265 := argvalue0.Read(context.Background(), jsProt264)
    if err265 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteStatement requires 1 args")
      flag.Usage()
    }
    arg266 := flag.Arg(1)
    mbTrans267 := thrift.NewTMemoryBufferLen(len(arg266))
    defer mbTrans267.Close()
    _, err268 := mbTrans267.WriteString(arg266)
    if err268 != nil {
      Usage()
      return
    }
    factory269 := thrift.NewTJSONProtocolFactory()
    jsProt270 := factory269.GetProtocol(mbTrans267)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err271 := argvalue0.Read(context.Background(), jsProt270)
    if err271 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeBatchStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteBatchStatement requires 1 args")
      flag.Usage()
    }
    arg272 := flag.Arg(1)
    mbTrans273 := thrift.NewTMemoryBufferLen(len(arg272))
    defer mbTrans273.Close()
    _, err274 := mbTrans273.WriteString(arg272)
    if err274 != nil {
      Usage()
      return
    }
    factory275 := thrift.NewTJSONProtocolFactory()
    jsProt276 := factory275.GetProtocol(mbTrans273)
    argvalue0 := rpc.NewTSExecuteBatchStatementReq()
    err277 := argvalue0.Read(context.Background(), jsProt276)
    if err277 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteBatchStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeQueryStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteQueryStatement requires 1 args")
      flag.Usage()
    }
    arg278 := flag.Arg(1)
    mbTrans279 := thrift.NewTMemoryBufferLen(len(arg278))
    defer mbTrans279.Close()
    _, err280 := mbTrans279.WriteString(arg278)
    if err280 != nil {
      Usage()
      return
    }
    factory281 := thrift.NewTJSONProtocolFactory()
    jsProt282 := factory281.GetProtocol(mbTrans279)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err283 := argvalue0.Read(context.Background(), jsProt282)
    if err283 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteQueryStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeUpdateStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteUpdateStatement requires 1 args")
      flag.Usage()
    }
    arg284 := flag.Arg(1)
    mbTrans285 := thrift.NewTMemoryBufferLen(len(arg284))
    defer mbTrans285.Close()
    _, err286 := mbTrans285.WriteString(arg284)
    if err286 != nil {
      Usage()
      return
    }
    factory287 := thrift.NewTJSONProtocolFactory()
    jsProt288 := factory287.GetProtocol(mbTrans285)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err289 := argvalue0.Read(context.Background(), jsProt288)
    if err289 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteUpdateStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchResults":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchResults requires 1 args")
      flag.Usage()
    }
    arg290 := flag.Arg(1)
    mbTrans291 := thrift.NewTMemoryBufferLen(len(arg290))
    defer mbTrans291.Close()
    _, err292 := mbTrans291.WriteString(arg290)
    if err292 != nil {
      Usage()
      return
    }
    factory293 := thrift.NewTJSONProtocolFactory()
    jsProt294 := factory293.GetProtocol(mbTrans291)
    argvalue0 := rpc.NewTSFetchResultsReq()
    err295 := argvalue0.Read(context.Background(), jsProt294)
    if err295 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchResults(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchMetadata":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchMetadata requires 1 args")
      flag.Usage()
    }
    arg296 := flag.Arg(1)
    mbTrans297 := thrift.NewTMemoryBufferLen(len(arg296))
    defer mbTrans297.Close()
    _, err298 := mbTrans297.WriteString(arg296)
    if err298 != nil {
      Usage()
      return
    }
    factory299 := thrift.NewTJSONProtocolFactory()
    jsProt300 := factory299.GetProtocol(mbTrans297)
    argvalue0 := rpc.NewTSFetchMetadataReq()
    err301 := argvalue0.Read(context.Background(), jsProt300)
    if err301 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchMetadata(context.Background(), value0))
    fmt.Print("\n")
    break
  case "cancelOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CancelOperation requires 1 args")
      flag.Usage()
    }
    arg302 := flag.Arg(1)
    mbTrans303 := thrift.NewTMemoryBufferLen(len(arg302))
    defer mbTrans303.Close()
    _, err304 := mbTrans303.WriteString(arg302)
    if err304 != nil {
      Usage()
      return
    }
    factory305 := thrift.NewTJSONProtocolFactory()
    jsProt306 := factory305.GetProtocol(mbTrans303)
    argvalue0 := rpc.NewTSCancelOperationReq()
    err307 := argvalue0.Read(context.Background(), jsProt306)
    if err307 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CancelOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseOperation requires 1 args")
      flag.Usage()
    }
    arg308 := flag.Arg(1)
    mbTrans309 := thrift.NewTMemoryBufferLen(len(arg308))
    defer mbTrans309.Close()
    _, err310 := mbTrans309.WriteString(arg308)
    if err310 != nil {
      Usage()
      return
    }
    factory311 := thrift.NewTJSONProtocolFactory()
    jsProt312 := factory311.GetProtocol(mbTrans309)
    argvalue0 := rpc.NewTSCloseOperationReq()
    err313 := argvalue0.Read(context.Background(), jsProt312)
    if err313 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetTimeZone requires 1 args")
      flag.Usage()
    }
    argvalue0, err314 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err314 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetTimeZone requires 1 args")
      flag.Usage()
    }
    arg315 := flag.Arg(1)
    mbTrans316 := thrift.NewTMemoryBufferLen(len(arg315))
    defer mbTrans316.Close()
    _, err317 := mbTrans316.WriteString(arg315)
    if err317 != nil {
      Usage()
      return
    }
    factory318 := thrift.NewTJSONProtocolFactory()
    jsProt319 := factory318.GetProtocol(mbTrans316)
    argvalue0 := rpc.NewTSSetTimeZoneReq()
    err320 := argvalue0.Read(context.Background(), jsProt319)
    if err320 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getProperties":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetProperties requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetProperties(context.Background()))
    fmt.Print("\n")
    break
  case "setStorageGroup":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "SetStorageGroup requires 2 args")
      flag.Usage()
    }
    argvalue0, err321 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err321 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    fmt.Print(client.SetStorageGroup(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "createTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateTimeseries requires 1 args")
      flag.Usage()
    }
    arg323 := flag.Arg(1)
    mbTrans324 := thrift.NewTMemoryBufferLen(len(arg323))
    defer mbTrans324.Close()
    _, err325 := mbTrans324.WriteString(arg323)
    if err325 != nil {
      Usage()
      return
    }
    factory326 := thrift.NewTJSONProtocolFactory()
    jsProt327 := factory326.GetProtocol(mbTrans324)
    argvalue0 := rpc.NewTSCreateTimeseriesReq()
    err328 := argvalue0.Read(context.Background(), jsProt327)
    if err328 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createMultiTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateMultiTimeseries requires 1 args")
      flag.Usage()
    }
    arg329 := flag.Arg(1)
    mbTrans330 := thrift.NewTMemoryBufferLen(len(arg329))
    defer mbTrans330.Close()
    _, err331 := mbTrans330.WriteString(arg329)
    if err331 != nil {
      Usage()
      return
    }
    factory332 := thrift.NewTJSONProtocolFactory()
    jsProt333 := factory332.GetProtocol(mbTrans330)
    argvalue0 := rpc.NewTSCreateMultiTimeseriesReq()
    err334 := argvalue0.Read(context.Background(), jsProt333)
    if err334 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateMultiTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteTimeseries":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteTimeseries requires 2 args")
      flag.Usage()
    }
    argvalue0, err335 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err335 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg336 := flag.Arg(2)
    mbTrans337 := thrift.NewTMemoryBufferLen(len(arg336))
    defer mbTrans337.Close()
    _, err338 := mbTrans337.WriteString(arg336)
    if err338 != nil { 
      Usage()
      return
    }
    factory339 := thrift.NewTJSONProtocolFactory()
    jsProt340 := factory339.GetProtocol(mbTrans337)
    containerStruct1 := rpc.NewTSIServiceDeleteTimeseriesArgs()
    err341 := containerStruct1.ReadField2(context.Background(), jsProt340)
    if err341 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Path
    value1 := argvalue1
    fmt.Print(client.DeleteTimeseries(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "deleteStorageGroups":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteStorageGroups requires 2 args")
      flag.Usage()
    }
    argvalue0, err342 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err342 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg343 := flag.Arg(2)
    mbTrans344 := thrift.NewTMemoryBufferLen(len(arg343))
    defer mbTrans344.Close()
    _, err345 := mbTrans344.WriteString(arg343)
    if err345 != nil { 
      Usage()
      return
    }
    factory346 := thrift.NewTJSONProtocolFactory()
    jsProt347 := factory346.GetProtocol(mbTrans344)
    containerStruct1 := rpc.NewTSIServiceDeleteStorageGroupsArgs()
    err348 := containerStruct1.ReadField2(context.Background(), jsProt347)
    if err348 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.StorageGroup
    value1 := argvalue1
    fmt.Print(client.DeleteStorageGroups(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "insertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecord requires 1 args")
      flag.Usage()
    }
    arg349 := flag.Arg(1)
    mbTrans350 := thrift.NewTMemoryBufferLen(len(arg349))
    defer mbTrans350.Close()
    _, err351 := mbTrans350.WriteString(arg349)
    if err351 != nil {
      Usage()
      return
    }
    factory352 := thrift.NewTJSONProtocolFactory()
    jsProt353 := factory352.GetProtocol(mbTrans350)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err354 := argvalue0.Read(context.Background(), jsProt353)
    if err354 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg355 := flag.Arg(1)
    mbTrans356 := thrift.NewTMemoryBufferLen(len(arg355))
    defer mbTrans356.Close()
    _, err357 := mbTrans356.WriteString(arg355)
    if err357 != nil {
      Usage()
      return
    }
    factory358 := thrift.NewTJSONProtocolFactory()
    jsProt359 := factory358.GetProtocol(mbTrans356)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err360 := argvalue0.Read(context.Background(), jsProt359)
    if err360 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablet requires 1 args")
      flag.Usage()
    }
    arg361 := flag.Arg(1)
    mbTrans362 := thrift.NewTMemoryBufferLen(len(arg361))
    defer mbTrans362.Close()
    _, err363 := mbTrans362.WriteString(arg361)
    if err363 != nil {
      Usage()
      return
    }
    factory364 := thrift.NewTJSONProtocolFactory()
    jsProt365 := factory364.GetProtocol(mbTrans362)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err366 := argvalue0.Read(context.Background(), jsProt365)
    if err366 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablets requires 1 args")
      flag.Usage()
    }
    arg367 := flag.Arg(1)
    mbTrans368 := thrift.NewTMemoryBufferLen(len(arg367))
    defer mbTrans368.Close()
    _, err369 := mbTrans368.WriteString(arg367)
    if err369 != nil {
      Usage()
      return
    }
    factory370 := thrift.NewTJSONProtocolFactory()
    jsProt371 := factory370.GetProtocol(mbTrans368)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err372 := argvalue0.Read(context.Background(), jsProt371)
    if err372 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecords requires 1 args")
      flag.Usage()
    }
    arg373 := flag.Arg(1)
    mbTrans374 := thrift.NewTMemoryBufferLen(len(arg373))
    defer mbTrans374.Close()
    _, err375 := mbTrans374.WriteString(arg373)
    if err375 != nil {
      Usage()
      return
    }
    factory376 := thrift.NewTJSONProtocolFactory()
    jsProt377 := factory376.GetProtocol(mbTrans374)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err378 := argvalue0.Read(context.Background(), jsProt377)
    if err378 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg379 := flag.Arg(1)
    mbTrans380 := thrift.NewTMemoryBufferLen(len(arg379))
    defer mbTrans380.Close()
    _, err381 := mbTrans380.WriteString(arg379)
    if err381 != nil {
      Usage()
      return
    }
    factory382 := thrift.NewTJSONProtocolFactory()
    jsProt383 := factory382.GetProtocol(mbTrans380)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err384 := argvalue0.Read(context.Background(), jsProt383)
    if err384 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg385 := flag.Arg(1)
    mbTrans386 := thrift.NewTMemoryBufferLen(len(arg385))
    defer mbTrans386.Close()
    _, err387 := mbTrans386.WriteString(arg385)
    if err387 != nil {
      Usage()
      return
    }
    factory388 := thrift.NewTJSONProtocolFactory()
    jsProt389 := factory388.GetProtocol(mbTrans386)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err390 := argvalue0.Read(context.Background(), jsProt389)
    if err390 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablet requires 1 args")
      flag.Usage()
    }
    arg391 := flag.Arg(1)
    mbTrans392 := thrift.NewTMemoryBufferLen(len(arg391))
    defer mbTrans392.Close()
    _, err393 := mbTrans392.WriteString(arg391)
    if err393 != nil {
      Usage()
      return
    }
    factory394 := thrift.NewTJSONProtocolFactory()
    jsProt395 := factory394.GetProtocol(mbTrans392)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err396 := argvalue0.Read(context.Background(), jsProt395)
    if err396 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablets requires 1 args")
      flag.Usage()
    }
    arg397 := flag.Arg(1)
    mbTrans398 := thrift.NewTMemoryBufferLen(len(arg397))
    defer mbTrans398.Close()
    _, err399 := mbTrans398.WriteString(arg397)
    if err399 != nil {
      Usage()
      return
    }
    factory400 := thrift.NewTJSONProtocolFactory()
    jsProt401 := factory400.GetProtocol(mbTrans398)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err402 := argvalue0.Read(context.Background(), jsProt401)
    if err402 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecord requires 1 args")
      flag.Usage()
    }
    arg403 := flag.Arg(1)
    mbTrans404 := thrift.NewTMemoryBufferLen(len(arg403))
    defer mbTrans404.Close()
    _, err405 := mbTrans404.WriteString(arg403)
    if err405 != nil {
      Usage()
      return
    }
    factory406 := thrift.NewTJSONProtocolFactory()
    jsProt407 := factory406.GetProtocol(mbTrans404)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err408 := argvalue0.Read(context.Background(), jsProt407)
    if err408 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg409 := flag.Arg(1)
    mbTrans410 := thrift.NewTMemoryBufferLen(len(arg409))
    defer mbTrans410.Close()
    _, err411 := mbTrans410.WriteString(arg409)
    if err411 != nil {
      Usage()
      return
    }
    factory412 := thrift.NewTJSONProtocolFactory()
    jsProt413 := factory412.GetProtocol(mbTrans410)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err414 := argvalue0.Read(context.Background(), jsProt413)
    if err414 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecords requires 1 args")
      flag.Usage()
    }
    arg415 := flag.Arg(1)
    mbTrans416 := thrift.NewTMemoryBufferLen(len(arg415))
    defer mbTrans416.Close()
    _, err417 := mbTrans416.WriteString(arg415)
    if err417 != nil {
      Usage()
      return
    }
    factory418 := thrift.NewTJSONProtocolFactory()
    jsProt419 := factory418.GetProtocol(mbTrans416)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err420 := argvalue0.Read(context.Background(), jsProt419)
    if err420 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg421 := flag.Arg(1)
    mbTrans422 := thrift.NewTMemoryBufferLen(len(arg421))
    defer mbTrans422.Close()
    _, err423 := mbTrans422.WriteString(arg421)
    if err423 != nil {
      Usage()
      return
    }
    factory424 := thrift.NewTJSONProtocolFactory()
    jsProt425 := factory424.GetProtocol(mbTrans422)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err426 := argvalue0.Read(context.Background(), jsProt425)
    if err426 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg427 := flag.Arg(1)
    mbTrans428 := thrift.NewTMemoryBufferLen(len(arg427))
    defer mbTrans428.Close()
    _, err429 := mbTrans428.WriteString(arg427)
    if err429 != nil {
      Usage()
      return
    }
    factory430 := thrift.NewTJSONProtocolFactory()
    jsProt431 := factory430.GetProtocol(mbTrans428)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err432 := argvalue0.Read(context.Background(), jsProt431)
    if err432 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteData":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "DeleteData requires 1 args")
      flag.Usage()
    }
    arg433 := flag.Arg(1)
    mbTrans434 := thrift.NewTMemoryBufferLen(len(arg433))
    defer mbTrans434.Close()
    _, err435 := mbTrans434.WriteString(arg433)
    if err435 != nil {
      Usage()
      return
    }
    factory436 := thrift.NewTJSONProtocolFactory()
    jsProt437 := factory436.GetProtocol(mbTrans434)
    argvalue0 := rpc.NewTSDeleteDataReq()
    err438 := argvalue0.Read(context.Background(), jsProt437)
    if err438 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.DeleteData(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeRawDataQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteRawDataQuery requires 1 args")
      flag.Usage()
    }
    arg439 := flag.Arg(1)
    mbTrans440 := thrift.NewTMemoryBufferLen(len(arg439))
    defer mbTrans440.Close()
    _, err441 := mbTrans440.WriteString(arg439)
    if err441 != nil {
      Usage()
      return
    }
    factory442 := thrift.NewTJSONProtocolFactory()
    jsProt443 := factory442.GetProtocol(mbTrans440)
    argvalue0 := rpc.NewTSRawDataQueryReq()
    err444 := argvalue0.Read(context.Background(), jsProt443)
    if err444 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteRawDataQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestStatementId":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestStatementId requires 1 args")
      flag.Usage()
    }
    argvalue0, err445 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err445 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestStatementId(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg446 := flag.Arg(1)
    mbTrans447 := thrift.NewTMemoryBufferLen(len(arg446))
    defer mbTrans447.Close()
    _, err448 := mbTrans447.WriteString(arg446)
    if err448 != nil {
      Usage()
      return
    }
    factory449 := thrift.NewTJSONProtocolFactory()
    jsProt450 := factory449.GetProtocol(mbTrans447)
    argvalue0 := rpc.NewTSCreateSchemaTemplateReq()
    err451 := argvalue0.Read(context.Background(), jsProt450)
    if err451 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg452 := flag.Arg(1)
    mbTrans453 := thrift.NewTMemoryBufferLen(len(arg452))
    defer mbTrans453.Close()
    _, err454 := mbTrans453.WriteString(arg452)
    if err454 != nil {
      Usage()
      return
    }
    factory455 := thrift.NewTJSONProtocolFactory()
    jsProt456 := factory455.GetProtocol(mbTrans453)
    argvalue0 := rpc.NewTSSetSchemaTemplateReq()
    err457 := argvalue0.Read(context.Background(), jsProt456)
    if err457 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
