/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.impl;

import java.util.ArrayList;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.protocol.influxdb.dto.IoTDBPoint;
import org.apache.iotdb.db.protocol.influxdb.input.InfluxLineParser;
import org.apache.iotdb.db.protocol.influxdb.meta.InfluxDBMetaManager;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.basic.BasicOpenSessionResp;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.utils.DataTypeUtils;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxDBService;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.TSCreateDatabaseReq;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.TSWritePointsReq;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.thrift.TException;
import org.influxdb.InfluxDBException;
import org.influxdb.dto.Point;

public class InfluxDBServiceImpl
implements InfluxDBService.Iface {
    private final ServiceProvider serviceProvider = IoTDB.serviceProvider;
    private final InfluxDBMetaManager metaManager = InfluxDBMetaManager.getInstance();

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        BasicOpenSessionResp basicOpenSessionResp = this.serviceProvider.openSession(req.username, req.password, req.zoneId, TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3);
        return new TSOpenSessionResp().setStatus(RpcUtils.getInfluxDBStatus((int)basicOpenSessionResp.getCode(), (String)basicOpenSessionResp.getMessage())).setSessionId(basicOpenSessionResp.getSessionId());
    }

    public org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus closeSession(TSCloseSessionReq req) {
        return new org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus(!this.serviceProvider.closeSession(req.sessionId) ? RpcUtils.getInfluxDBStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR) : RpcUtils.getInfluxDBStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
    }

    public org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus writePoints(TSWritePointsReq req) {
        org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus loginStatus = this.checkLoginStatus(req.sessionId);
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        ArrayList<org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus> tsStatusList = new ArrayList<org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus>();
        int executeCode = TSStatusCode.SUCCESS_STATUS.getStatusCode();
        for (Point point : InfluxLineParser.parserRecordsToPointsWithPrecision(req.lineProtocol, req.precision)) {
            IoTDBPoint iotdbPoint = new IoTDBPoint(req.database, point, this.metaManager);
            try {
                InsertRowPlan plan = iotdbPoint.convertToInsertRowPlan();
                org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus tsStatus = this.executeNonQueryPlan(plan, req.sessionId);
                if (executeCode == TSStatusCode.SUCCESS_STATUS.getStatusCode() && tsStatus.getCode() == TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()) {
                    executeCode = tsStatus.getCode();
                }
                tsStatusList.add(tsStatus);
            }
            catch (StorageEngineException | IllegalPathException | StorageGroupNotSetException | QueryProcessException | IoTDBConnectionException e) {
                throw new InfluxDBException(e.getMessage());
            }
        }
        return new org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus().setCode(executeCode).setSubStatus(tsStatusList);
    }

    private boolean isStatusNotSuccess(org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus tsStatus) {
        return tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode();
    }

    private org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus checkLoginStatus(long sessionId) {
        if (!this.serviceProvider.checkLogin(sessionId)) {
            return this.getNotLoggedInStatus();
        }
        if (this.serviceProvider.checkSessionTimeout(sessionId)) {
            return RpcUtils.getInfluxDBStatus((int)TSStatusCode.SESSION_TIMEOUT.getStatusCode(), (String)"Session timeout");
        }
        return RpcUtils.getInfluxDBStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus createDatabase(TSCreateDatabaseReq req) throws TException {
        org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus loginStatus = this.checkLoginStatus(req.sessionId);
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        try {
            SetStorageGroupPlan setStorageGroupPlan = new SetStorageGroupPlan(new PartialPath("root." + req.getDatabase()));
            return this.executeNonQueryPlan(setStorageGroupPlan, req.getSessionId());
        }
        catch (StorageEngineException | IllegalPathException | StorageGroupNotSetException | QueryProcessException e) {
            if (e instanceof QueryProcessException && e.getErrorCode() == 300) {
                return RpcUtils.getInfluxDBStatus((int)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (String)"Execute successfully");
            }
            throw new InfluxDBException(e.getMessage());
        }
    }

    public void handleClientExit() {
        Long sessionId = ServiceProvider.SESSION_MANAGER.getCurrSessionId();
        if (sessionId != null) {
            this.closeSession(new TSCloseSessionReq(sessionId.longValue()));
        }
    }

    private org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus getNotLoggedInStatus() {
        return RpcUtils.getInfluxDBStatus((int)TSStatusCode.NOT_LOGIN_ERROR.getStatusCode(), (String)"Log in failed. Either you are not authorized or the session has timed out.");
    }

    private org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus executeNonQueryPlan(PhysicalPlan plan, long sessionId) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        TSStatus status = this.serviceProvider.checkAuthority(plan, sessionId);
        if (status == null) {
            status = this.serviceProvider.executeNonQuery(plan) ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully") : RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
        return DataTypeUtils.RPCStatusToInfluxDBTSStatus(status);
    }
}

