/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.layer;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.db.query.udf.core.access.ElasticSerializableTVListBackedSingleColumnRow;
import org.apache.iotdb.db.query.udf.core.access.ElasticSerializableTVListBackedSingleColumnWindow;
import org.apache.iotdb.db.query.udf.core.layer.IntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.LayerCacheUtils;
import org.apache.iotdb.db.query.udf.core.layer.SafetyLine;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.core.reader.LayerRowReader;
import org.apache.iotdb.db.query.udf.core.reader.LayerRowWindowReader;
import org.apache.iotdb.db.query.udf.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInputColumnMultiReferenceIntermediateLayer
extends IntermediateLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleInputColumnMultiReferenceIntermediateLayer.class);
    private final LayerPointReader parentLayerPointReader;
    private final TSDataType dataType;
    private final ElasticSerializableTVList tvList;
    private final SafetyLine safetyLine;

    public SingleInputColumnMultiReferenceIntermediateLayer(Expression expression, long queryId, float memoryBudgetInMB, LayerPointReader parentLayerPointReader) throws QueryProcessException {
        super(expression, queryId, memoryBudgetInMB);
        this.parentLayerPointReader = parentLayerPointReader;
        this.dataType = parentLayerPointReader.getDataType();
        this.tvList = ElasticSerializableTVList.newElasticSerializableTVList(this.dataType, queryId, memoryBudgetInMB, 2);
        this.safetyLine = new SafetyLine();
    }

    @Override
    public LayerPointReader constructPointReader() {
        return new LayerPointReader(){
            private final SafetyLine.SafetyPile safetyPile;
            private boolean hasCached;
            private int currentPointIndex;
            {
                this.safetyPile = SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.addSafetyPile();
                this.hasCached = false;
                this.currentPointIndex = -1;
            }

            @Override
            public boolean isConstantPointReader() {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader.isConstantPointReader();
            }

            @Override
            public boolean next() throws QueryProcessException, IOException {
                if (!this.hasCached && (this.currentPointIndex < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1 || LayerCacheUtils.cachePoint(SingleInputColumnMultiReferenceIntermediateLayer.this.dataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList))) {
                    ++this.currentPointIndex;
                    this.hasCached = true;
                }
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.safetyPile.moveForwardTo(this.currentPointIndex + 1);
                SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.setEvictionUpperBound(SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.getSafetyLine());
            }

            @Override
            public TSDataType getDataType() {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.dataType;
            }

            @Override
            public long currentTime() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.currentPointIndex);
            }

            @Override
            public int currentInt() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getInt(this.currentPointIndex);
            }

            @Override
            public long currentLong() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getLong(this.currentPointIndex);
            }

            @Override
            public float currentFloat() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getFloat(this.currentPointIndex);
            }

            @Override
            public double currentDouble() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getDouble(this.currentPointIndex);
            }

            @Override
            public boolean currentBoolean() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getBoolean(this.currentPointIndex);
            }

            @Override
            public Binary currentBinary() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getBinary(this.currentPointIndex);
            }

            @Override
            public boolean isCurrentNull() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.isNull(this.currentPointIndex);
            }
        };
    }

    @Override
    public LayerRowReader constructRowReader() {
        return new LayerRowReader(){
            private final SafetyLine.SafetyPile safetyPile;
            private final ElasticSerializableTVListBackedSingleColumnRow row;
            private boolean hasCached;
            private int currentRowIndex;
            {
                this.safetyPile = SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.addSafetyPile();
                this.row = new ElasticSerializableTVListBackedSingleColumnRow(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList, -1);
                this.hasCached = false;
                this.currentRowIndex = -1;
            }

            @Override
            public boolean next() throws QueryProcessException, IOException {
                if (!this.hasCached && (this.currentRowIndex < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1 || LayerCacheUtils.cachePoint(SingleInputColumnMultiReferenceIntermediateLayer.this.dataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList))) {
                    this.row.seek(++this.currentRowIndex);
                    this.hasCached = true;
                }
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.safetyPile.moveForwardTo(this.currentRowIndex + 1);
                SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.setEvictionUpperBound(SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.getSafetyLine());
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnMultiReferenceIntermediateLayer.this.dataType};
            }

            @Override
            public long currentTime() throws IOException {
                return this.row.getTime();
            }

            @Override
            public Row currentRow() {
                return this.row;
            }

            @Override
            public boolean isCurrentNull() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.isNull(this.currentRowIndex);
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingSizeWindowReader(final SlidingSizeWindowAccessStrategy strategy, float memoryBudgetInMB) {
        return new LayerRowWindowReader(){
            private final int windowSize;
            private final int slidingStep;
            private final SafetyLine.SafetyPile safetyPile;
            private final ElasticSerializableTVListBackedSingleColumnWindow window;
            private boolean hasCached;
            private int beginIndex;
            {
                this.windowSize = strategy.getWindowSize();
                this.slidingStep = strategy.getSlidingStep();
                this.safetyPile = SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.addSafetyPile();
                this.window = new ElasticSerializableTVListBackedSingleColumnWindow(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList);
                this.hasCached = false;
                this.beginIndex = -this.slidingStep;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.hasCached) {
                    return true;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                if (this.beginIndex < 0 || endIndex < 0) {
                    LOGGER.warn("SingleInputColumnMultiReferenceIntermediateLayer$LayerRowWindowReader: index overflow. beginIndex: {}, endIndex: {}, windowSize: {}.", new Object[]{this.beginIndex, endIndex, this.windowSize});
                    return false;
                }
                int pointsToBeCollected = endIndex - SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                if (0 < pointsToBeCollected) {
                    LayerCacheUtils.cachePoints(SingleInputColumnMultiReferenceIntermediateLayer.this.dataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList, pointsToBeCollected);
                    if (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() <= this.beginIndex) {
                        return false;
                    }
                    this.window.seek(this.beginIndex, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size(), SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.beginIndex), SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1));
                } else {
                    this.window.seek(this.beginIndex, endIndex, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.beginIndex), SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(endIndex - 1));
                }
                this.hasCached = true;
                return true;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.safetyPile.moveForwardTo(this.beginIndex + 1);
                SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.setEvictionUpperBound(SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.getSafetyLine());
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnMultiReferenceIntermediateLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return this.window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingTimeWindowReader(SlidingTimeWindowAccessStrategy strategy, float memoryBudgetInMB) throws IOException, QueryProcessException {
        final long timeInterval = strategy.getTimeInterval();
        final long slidingStep = strategy.getSlidingStep();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final SafetyLine.SafetyPile safetyPile = this.safetyLine.addSafetyPile();
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(this.tvList);
        long nextWindowTimeBeginGivenByStrategy = strategy.getDisplayWindowBegin();
        if (this.tvList.size() == 0 && LayerCacheUtils.cachePoint(this.dataType, this.parentLayerPointReader, this.tvList) && nextWindowTimeBeginGivenByStrategy == Long.MIN_VALUE) {
            nextWindowTimeBeginGivenByStrategy = this.tvList.getTime(0);
        }
        final long finalNextWindowTimeBeginGivenByStrategy = nextWindowTimeBeginGivenByStrategy;
        final boolean hasAtLeastOneRow = this.tvList.size() != 0;
        return new LayerRowWindowReader(){
            private boolean hasCached = false;
            private long nextWindowTimeBegin = finalNextWindowTimeBeginGivenByStrategy;
            private int nextIndexBegin = 0;

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.hasCached) {
                    return true;
                }
                if (!hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return false;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) < nextWindowTimeEnd && LayerCacheUtils.cachePoint(SingleInputColumnMultiReferenceIntermediateLayer.this.dataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList)) {
                }
                for (int i = this.nextIndexBegin; i < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) continue;
                    this.nextIndexBegin = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                }
                int nextIndexEnd = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                for (int i = this.nextIndexBegin; i < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size(); ++i) {
                    if (nextWindowTimeEnd > SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(i)) continue;
                    nextIndexEnd = i;
                    break;
                }
                window.seek(this.nextIndexBegin, nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != nextIndexEnd;
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.nextWindowTimeBegin += slidingStep;
                safetyPile.moveForwardTo(this.nextIndexBegin + 1);
                SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.setEvictionUpperBound(SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.getSafetyLine());
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnMultiReferenceIntermediateLayer.this.dataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }
}

