/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.template.Template;

public abstract class Traverser {
    protected IMNode startNode;
    protected String[] nodes;
    protected Deque<IMNode> traverseContext;
    protected boolean shouldTraverseTemplate = false;
    protected boolean isPrefixMatch = false;

    public Traverser(IMNode startNode, PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(startNode.getName())) {
            throw new IllegalPathException(path.getFullPath(), path.getFullPath() + " doesn't start with " + startNode.getName());
        }
        this.startNode = startNode;
        this.nodes = nodes;
        this.traverseContext = new ArrayDeque<IMNode>();
    }

    public void traverse() throws MetadataException {
        this.traverse(this.startNode, 0, 0);
    }

    protected void traverse(IMNode node, int idx, int level) throws MetadataException {
        if (this.processMatchedMNode(node, idx, level)) {
            return;
        }
        if (idx >= this.nodes.length - 1) {
            if (this.nodes[this.nodes.length - 1].equals("**") || this.isPrefixMatch) {
                this.processMultiLevelWildcard(node, idx, level);
            }
            return;
        }
        if (node.isMeasurement()) {
            return;
        }
        String targetName = this.nodes[idx + 1];
        if ("**".equals(targetName)) {
            this.processMultiLevelWildcard(node, idx, level);
        } else if (targetName.contains("*")) {
            this.processOneLevelWildcard(node, idx, level);
        } else {
            this.processNameMatch(node, idx, level);
        }
    }

    private boolean processMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
        if (idx < this.nodes.length - 1) {
            return this.processInternalMatchedMNode(node, idx, level);
        }
        return this.processFullMatchedMNode(node, idx, level);
    }

    protected abstract boolean processInternalMatchedMNode(IMNode var1, int var2, int var3) throws MetadataException;

    protected abstract boolean processFullMatchedMNode(IMNode var1, int var2, int var3) throws MetadataException;

    protected void processMultiLevelWildcard(IMNode node, int idx, int level) throws MetadataException {
        this.traverseContext.push(node);
        for (IMNode child : node.getChildren().values()) {
            this.traverse(child, idx + 1, level + 1);
        }
        this.traverseContext.pop();
        if (!this.shouldTraverseTemplate) {
            return;
        }
        if (!node.isUseTemplate()) {
            return;
        }
        Template upperTemplate = node.getUpperTemplate();
        this.traverseContext.push(node);
        for (IMNode child : upperTemplate.getDirectNodes()) {
            this.traverse(child, idx + 1, level + 1);
        }
        this.traverseContext.pop();
    }

    protected void processOneLevelWildcard(IMNode node, int idx, int level) throws MetadataException {
        boolean multiLevelWildcard = this.nodes[idx].equals("**");
        String targetNameRegex = this.nodes[idx + 1].replace("*", ".*");
        this.traverseContext.push(node);
        for (IMNode child : node.getChildren().values()) {
            if (child.isMeasurement()) {
                String alias = child.getAsMeasurementMNode().getAlias();
                if (!(Pattern.matches(targetNameRegex, child.getName()) || alias != null && Pattern.matches(targetNameRegex, alias))) {
                    continue;
                }
            } else if (!Pattern.matches(targetNameRegex, child.getName())) continue;
            this.traverse(child, idx + 1, level + 1);
        }
        this.traverseContext.pop();
        if (multiLevelWildcard) {
            this.traverseContext.push(node);
            for (IMNode child : node.getChildren().values()) {
                this.traverse(child, idx, level + 1);
            }
            this.traverseContext.pop();
        }
        if (!this.shouldTraverseTemplate) {
            return;
        }
        if (!node.isUseTemplate()) {
            return;
        }
        Template upperTemplate = node.getUpperTemplate();
        this.traverseContext.push(node);
        for (IMNode child : upperTemplate.getDirectNodes()) {
            if (!Pattern.matches(targetNameRegex, child.getName())) continue;
            this.traverse(child, idx + 1, level + 1);
        }
        this.traverseContext.pop();
        if (multiLevelWildcard) {
            this.traverseContext.push(node);
            for (IMNode child : upperTemplate.getDirectNodes()) {
                this.traverse(child, idx, level + 1);
            }
            this.traverseContext.pop();
        }
    }

    protected void processNameMatch(IMNode node, int idx, int level) throws MetadataException {
        boolean multiLevelWildcard = this.nodes[idx].equals("**");
        String targetName = this.nodes[idx + 1];
        IMNode next = node.getChild(targetName);
        if (next != null) {
            this.traverseContext.push(node);
            this.traverse(next, idx + 1, level + 1);
            this.traverseContext.pop();
        }
        if (multiLevelWildcard) {
            this.traverseContext.push(node);
            for (IMNode child : node.getChildren().values()) {
                this.traverse(child, idx, level + 1);
            }
            this.traverseContext.pop();
        }
        if (!this.shouldTraverseTemplate) {
            return;
        }
        if (!node.isUseTemplate()) {
            return;
        }
        Template upperTemplate = node.getUpperTemplate();
        IMNode targetNode = upperTemplate.getDirectNode(targetName);
        if (targetNode != null) {
            this.traverseContext.push(node);
            this.traverse(targetNode, idx + 1, level + 1);
            this.traverseContext.pop();
        }
        if (multiLevelWildcard) {
            this.traverseContext.push(node);
            for (IMNode child : upperTemplate.getDirectNodes()) {
                this.traverse(child, idx, level + 1);
            }
            this.traverseContext.pop();
        }
    }

    public void setPrefixMatch(boolean isPrefixMatch) {
        this.isPrefixMatch = isPrefixMatch;
    }

    public void setShouldTraverseTemplate(boolean shouldTraverseTemplate) {
        this.shouldTraverseTemplate = shouldTraverseTemplate;
    }

    protected PartialPath getCurrentPartialPath(IMNode currentNode) throws IllegalPathException {
        StringBuilder builder;
        Iterator<IMNode> nodes = this.traverseContext.descendingIterator();
        StringBuilder stringBuilder = builder = nodes.hasNext() ? new StringBuilder(nodes.next().getName()) : new StringBuilder();
        while (nodes.hasNext()) {
            builder.append(".");
            builder.append(nodes.next().getName());
        }
        if (builder.length() != 0) {
            builder.append(".");
        }
        builder.append(currentNode.getName());
        return new PartialPath(builder.toString());
    }

    protected IMNode getStorageGroupNodeInTraversePath() {
        for (IMNode node : this.traverseContext) {
            if (!node.isStorageGroup()) continue;
            return node;
        }
        return null;
    }
}

