/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.upgrade;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeLog {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeLog.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String UPGRADE_DIR = "upgrade";
    private static final String UPGRADE_LOG_NAME = "upgrade.txt";
    private static BufferedWriter upgradeLogWriter;
    private static File upgradeLogPath;

    public static boolean createUpgradeLog() {
        try {
            if (!upgradeLogPath.getParentFile().exists()) {
                upgradeLogPath.getParentFile().mkdirs();
            }
            upgradeLogPath.createNewFile();
            upgradeLogWriter = new BufferedWriter(new FileWriter(UpgradeLog.getUpgradeLogPath(), true));
            return true;
        }
        catch (IOException e) {
            logger.error("meet error when create upgrade log, file path:{}", (Object)upgradeLogPath, (Object)e);
            return false;
        }
    }

    public static String getUpgradeLogPath() {
        return upgradeLogPath.getAbsolutePath();
    }

    public static boolean writeUpgradeLogFile(String content) {
        UpgradeUtils.getUpgradeLogLock().writeLock().lock();
        try {
            upgradeLogWriter.write(content);
            upgradeLogWriter.newLine();
            upgradeLogWriter.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error("write upgrade log file failed, the log file:{}", (Object)UpgradeLog.getUpgradeLogPath(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            UpgradeUtils.getUpgradeLogLock().writeLock().unlock();
        }
    }

    public static void closeLogWriter() {
        try {
            if (upgradeLogWriter != null) {
                upgradeLogWriter.close();
            }
        }
        catch (IOException e) {
            logger.error("close upgrade log file failed, the log file:{}", (Object)UpgradeLog.getUpgradeLogPath(), (Object)e);
        }
    }

    static {
        upgradeLogPath = SystemFileFactory.INSTANCE.getFile(SystemFileFactory.INSTANCE.getFile(config.getSystemDir(), UPGRADE_DIR), UPGRADE_LOG_NAME);
    }
}

