/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import java.util.List;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.auth.entity.PrivilegeType;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorityChecker {
    private static final String SUPER_USER = IoTDBDescriptor.getInstance().getConfig().getAdminName();
    private static final Logger logger = LoggerFactory.getLogger(AuthorityChecker.class);

    private AuthorityChecker() {
    }

    public static boolean check(String username, List<? extends PartialPath> paths, Operator.OperatorType type, String targetUser) throws AuthException {
        if (SUPER_USER.equals(username)) {
            return true;
        }
        int permission = AuthorityChecker.translateToPermissionId(type);
        if (permission == -1) {
            return false;
        }
        if (permission == PrivilegeType.MODIFY_PASSWORD.ordinal() && username.equals(targetUser)) {
            return true;
        }
        if (paths != null && !paths.isEmpty()) {
            for (PartialPath partialPath : paths) {
                if (AuthorityChecker.checkOnePath(username, partialPath, permission)) continue;
                return false;
            }
        } else {
            return AuthorityChecker.checkOnePath(username, null, permission);
        }
        return true;
    }

    private static boolean checkOnePath(String username, PartialPath path, int permission) throws AuthException {
        IAuthorizer authorizer = BasicAuthorizer.getInstance();
        try {
            String fullPath;
            String string = fullPath = path == null ? "root" : path.getFullPath();
            if (authorizer.checkUserPrivileges(username, fullPath, permission)) {
                return true;
            }
        }
        catch (AuthException e) {
            logger.error("Error occurs when checking the seriesPath {} for user {}", new Object[]{path, username, e});
        }
        return false;
    }

    private static int translateToPermissionId(Operator.OperatorType type) {
        switch (type) {
            case GRANT_ROLE_PRIVILEGE: {
                return PrivilegeType.GRANT_ROLE_PRIVILEGE.ordinal();
            }
            case CREATE_ROLE: {
                return PrivilegeType.CREATE_ROLE.ordinal();
            }
            case CREATE_USER: {
                return PrivilegeType.CREATE_USER.ordinal();
            }
            case MODIFY_PASSWORD: {
                return PrivilegeType.MODIFY_PASSWORD.ordinal();
            }
            case GRANT_USER_PRIVILEGE: {
                return PrivilegeType.GRANT_USER_PRIVILEGE.ordinal();
            }
            case REVOKE_ROLE_PRIVILEGE: {
                return PrivilegeType.REVOKE_ROLE_PRIVILEGE.ordinal();
            }
            case REVOKE_USER_PRIVILEGE: {
                return PrivilegeType.REVOKE_USER_PRIVILEGE.ordinal();
            }
            case GRANT_USER_ROLE: {
                return PrivilegeType.GRANT_USER_ROLE.ordinal();
            }
            case DELETE_USER: {
                return PrivilegeType.DELETE_USER.ordinal();
            }
            case DELETE_ROLE: {
                return PrivilegeType.DELETE_ROLE.ordinal();
            }
            case REVOKE_USER_ROLE: {
                return PrivilegeType.REVOKE_USER_ROLE.ordinal();
            }
            case SET_STORAGE_GROUP: {
                return PrivilegeType.SET_STORAGE_GROUP.ordinal();
            }
            case CREATE_TIMESERIES: 
            case CREATE_ALIGNED_TIMESERIES: {
                return PrivilegeType.CREATE_TIMESERIES.ordinal();
            }
            case DELETE_TIMESERIES: 
            case DEACTIVATE_TEMPLATE: 
            case DELETE: 
            case DROP_INDEX: {
                return PrivilegeType.DELETE_TIMESERIES.ordinal();
            }
            case SHOW: 
            case QUERY: 
            case GROUP_BY_TIME: 
            case QUERY_INDEX: 
            case AGGREGATION: 
            case UDAF: 
            case UDTF: 
            case LAST: 
            case FILL: 
            case GROUP_BY_FILL: 
            case SELECT_INTO: {
                return PrivilegeType.READ_TIMESERIES.ordinal();
            }
            case INSERT: 
            case LOAD_DATA: 
            case CREATE_INDEX: 
            case BATCH_INSERT: 
            case BATCH_INSERT_ONE_DEVICE: 
            case BATCH_INSERT_ROWS: 
            case MULTI_BATCH_INSERT: {
                return PrivilegeType.INSERT_TIMESERIES.ordinal();
            }
            case LIST_ROLE: 
            case LIST_ROLE_USERS: 
            case LIST_ROLE_PRIVILEGE: {
                return PrivilegeType.LIST_ROLE.ordinal();
            }
            case LIST_USER: 
            case LIST_USER_ROLES: 
            case LIST_USER_PRIVILEGE: {
                return PrivilegeType.LIST_USER.ordinal();
            }
            case CREATE_FUNCTION: {
                return PrivilegeType.CREATE_FUNCTION.ordinal();
            }
            case DROP_FUNCTION: {
                return PrivilegeType.DROP_FUNCTION.ordinal();
            }
            case CREATE_TRIGGER: {
                return PrivilegeType.CREATE_TRIGGER.ordinal();
            }
            case DROP_TRIGGER: {
                return PrivilegeType.DROP_TRIGGER.ordinal();
            }
            case START_TRIGGER: {
                return PrivilegeType.START_TRIGGER.ordinal();
            }
            case STOP_TRIGGER: {
                return PrivilegeType.STOP_TRIGGER.ordinal();
            }
            case CREATE_CONTINUOUS_QUERY: {
                return PrivilegeType.CREATE_CONTINUOUS_QUERY.ordinal();
            }
            case DROP_CONTINUOUS_QUERY: {
                return PrivilegeType.DROP_CONTINUOUS_QUERY.ordinal();
            }
            case CREATE_TEMPLATE: 
            case APPEND_TEMPLATE: 
            case DROP_TEMPLATE: 
            case PRUNE_TEMPLATE: {
                return PrivilegeType.UPDATE_TEMPLATE.ordinal();
            }
            case ACTIVATE_TEMPLATE: 
            case SET_TEMPLATE: 
            case UNSET_TEMPLATE: {
                return PrivilegeType.APPLY_TEMPLATE.ordinal();
            }
        }
        logger.error("Unrecognizable operator type ({}) for AuthorityChecker.", (Object)type);
        return -1;
    }
}

