/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard.reporter;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.iotdb.metrics.dropwizard.reporter.MetricType;

class PrometheusTextWriter
extends FilterWriter {
    public PrometheusTextWriter(Writer out) {
        super(out);
    }

    public void writeHelp(String name, String value) throws IOException {
        this.write("# HELP ");
        this.write(name);
        this.write(32);
        this.write(value);
        this.write(10);
    }

    public void writeType(String name, MetricType type) throws IOException {
        this.write("# TYPE ");
        this.write(name);
        this.write(32);
        this.write(type.getText());
        this.write(10);
    }

    public void writeSample(String name, Map<String, String> labels, double value) throws IOException {
        this.write(name);
        if (labels.size() > 0) {
            this.write(123);
            for (Map.Entry<String, String> entry : labels.entrySet()) {
                this.write(entry.getKey());
                this.write("=\"");
                this.write(entry.getValue());
                this.write("\",");
            }
            this.write(125);
        }
        this.write(32);
        this.write(PrometheusTextWriter.doubleToGoString(value));
        this.write(10);
    }

    private static String doubleToGoString(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return "+Inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        return Double.toString(d);
    }
}

