/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.predefined.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import org.apache.iotdb.metrics.MetricManager;
import org.apache.iotdb.metrics.predefined.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.PredefinedMetric;

public class JvmThreadMetrics
implements IMetricSet {
    @Override
    public void bindTo(MetricManager metricManager) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        metricManager.getOrCreateAutoGauge("jvm.threads.peak.threads", MetricLevel.IMPORTANT, threadBean, ThreadMXBean::getPeakThreadCount, new String[0]);
        metricManager.getOrCreateAutoGauge("jvm.threads.daemon.threads", MetricLevel.IMPORTANT, threadBean, ThreadMXBean::getDaemonThreadCount, new String[0]);
        metricManager.getOrCreateAutoGauge("jvm.threads.live.threads", MetricLevel.IMPORTANT, threadBean, ThreadMXBean::getThreadCount, new String[0]);
        try {
            threadBean.getAllThreadIds();
            for (Thread.State state : Thread.State.values()) {
                metricManager.getOrCreateAutoGauge("jvm.threads.states.threads", MetricLevel.IMPORTANT, threadBean, bean -> JvmThreadMetrics.getThreadStateCount(bean, state), "state", JvmThreadMetrics.getStateTagValue(state));
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    static long getThreadStateCount(ThreadMXBean threadBean, Thread.State state) {
        return Arrays.stream(threadBean.getThreadInfo(threadBean.getAllThreadIds())).filter(threadInfo -> threadInfo != null && threadInfo.getThreadState() == state).count();
    }

    private static String getStateTagValue(Thread.State state) {
        return state.name().toLowerCase().replace("_", "-");
    }

    @Override
    public PredefinedMetric getType() {
        return PredefinedMetric.JVM;
    }
}

