/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.config;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MonitorType;
import org.apache.iotdb.metrics.utils.PredefinedMetric;
import org.apache.iotdb.metrics.utils.ReporterType;

public class MetricConfig {
    private Boolean enableMetric = false;
    private Boolean enablePerformanceStat = false;
    private MonitorType monitorType = MonitorType.MICROMETER;
    private List<ReporterType> metricReporterList = Arrays.asList(ReporterType.JMX, ReporterType.PROMETHEUS);
    private MetricLevel metricLevel = MetricLevel.IMPORTANT;
    private List<PredefinedMetric> predefinedMetrics = Arrays.asList(PredefinedMetric.JVM, PredefinedMetric.FILE);
    private String prometheusExporterPort = "9091";
    private IoTDBReporterConfig ioTDBReporterConfig = new IoTDBReporterConfig();
    private String instanceHost = "127.0.0.1";
    private Integer instancePort = 6667;

    public void copy(MetricConfig newMetricConfig) {
        this.enableMetric = newMetricConfig.getEnableMetric();
        this.monitorType = newMetricConfig.getMonitorType();
        this.metricReporterList = newMetricConfig.getMetricReporterList();
        this.metricLevel = newMetricConfig.getMetricLevel();
        this.predefinedMetrics = newMetricConfig.getPredefinedMetrics();
        this.prometheusExporterPort = newMetricConfig.getPrometheusExporterPort();
        this.ioTDBReporterConfig = newMetricConfig.ioTDBReporterConfig;
    }

    public void updateInstance(String instanceHost, Integer instancePort) {
        this.instanceHost = instanceHost;
        this.instancePort = instancePort;
    }

    public Boolean getEnableMetric() {
        return this.enableMetric;
    }

    public void setEnableMetric(Boolean enableMetric) {
        this.enableMetric = enableMetric;
    }

    public Boolean getEnablePerformanceStat() {
        return this.enablePerformanceStat;
    }

    public void setEnablePerformanceStat(Boolean enablePerformanceStat) {
        this.enablePerformanceStat = enablePerformanceStat;
    }

    public MonitorType getMonitorType() {
        return this.monitorType;
    }

    public void setMonitorType(MonitorType monitorType) {
        this.monitorType = monitorType;
    }

    public List<ReporterType> getMetricReporterList() {
        return this.metricReporterList;
    }

    public void setMetricReporterList(List<ReporterType> metricReporterList) {
        this.metricReporterList = metricReporterList;
    }

    public MetricLevel getMetricLevel() {
        return this.metricLevel;
    }

    public void setMetricLevel(MetricLevel metricLevel) {
        this.metricLevel = metricLevel;
    }

    public List<PredefinedMetric> getPredefinedMetrics() {
        return this.predefinedMetrics;
    }

    public void setPredefinedMetrics(List<PredefinedMetric> predefinedMetrics) {
        this.predefinedMetrics = predefinedMetrics;
    }

    public String getPrometheusExporterPort() {
        return this.prometheusExporterPort;
    }

    public void setPrometheusExporterPort(String prometheusExporterPort) {
        this.prometheusExporterPort = prometheusExporterPort;
    }

    public IoTDBReporterConfig getIoTDBReporterConfig() {
        return this.ioTDBReporterConfig;
    }

    public void setIoTDBReporterConfig(IoTDBReporterConfig ioTDBReporterConfig) {
        this.ioTDBReporterConfig = ioTDBReporterConfig;
    }

    public String getInstanceHost() {
        return this.instanceHost;
    }

    public Integer getInstancePort() {
        return this.instancePort;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetricConfig)) {
            return false;
        }
        MetricConfig anotherMetricConfig = (MetricConfig)obj;
        return this.enableMetric.equals(anotherMetricConfig.getEnableMetric()) && this.monitorType.equals((Object)anotherMetricConfig.getMonitorType()) && this.metricReporterList.equals(anotherMetricConfig.getMetricReporterList()) && this.metricLevel.equals((Object)anotherMetricConfig.getMetricLevel()) && this.predefinedMetrics.equals(anotherMetricConfig.getPredefinedMetrics()) && this.prometheusExporterPort.equals(anotherMetricConfig.getPrometheusExporterPort()) && this.ioTDBReporterConfig.equals(anotherMetricConfig.getIoTDBReporterConfig());
    }

    public static class IoTDBReporterConfig {
        private String host = "127.0.0.1";
        private Integer port = 6667;
        private String username = "root";
        private String password = "root";
        private String database = "_metric";
        private Integer pushPeriodInSecond = 15;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public Integer getPushPeriodInSecond() {
            return this.pushPeriodInSecond;
        }

        public void setPushPeriodInSecond(Integer pushPeriodInSecond) {
            this.pushPeriodInSecond = pushPeriodInSecond;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IoTDBReporterConfig that = (IoTDBReporterConfig)o;
            return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.database, that.database) && Objects.equals(this.pushPeriodInSecond, that.pushPeriodInSecond);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port, this.username, this.password, this.database, this.pushPeriodInSecond);
        }
    }
}

