/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util.collection;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.util.JdkVersion;
import org.glassfish.jersey.internal.util.collection.ConcurrentHashMapV8;

public final class DataStructures {
    private static final Class<?> LTQ_CLASS;
    public static final int DEFAULT_CONCURENCY_LEVEL;

    private static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    private static Class<?> getAndVerify(final String cn) throws Throwable {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    return DataStructures.class.getClassLoader().loadClass(cn).newInstance().getClass();
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw ex.getCause();
        }
    }

    public static <E> BlockingQueue<E> createLinkedTransferQueue() {
        try {
            return (BlockingQueue)AccessController.doPrivileged(new PrivilegedExceptionAction<BlockingQueue<E>>(){

                @Override
                public BlockingQueue<E> run() throws Exception {
                    return (BlockingQueue)LTQ_CLASS.newInstance();
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentMap() {
        return (ConcurrentMap)((Object)(JdkVersion.getJdkVersion().isUnsafeSupported() ? new ConcurrentHashMapV8() : new ConcurrentHashMap()));
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentMap(Map<? extends K, ? extends V> map) {
        return (ConcurrentMap)((Object)(JdkVersion.getJdkVersion().isUnsafeSupported() ? new ConcurrentHashMapV8<K, V>(map) : new ConcurrentHashMap<K, V>(map)));
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity) {
        return (ConcurrentMap)((Object)(JdkVersion.getJdkVersion().isUnsafeSupported() ? new ConcurrentHashMapV8(initialCapacity) : new ConcurrentHashMap(initialCapacity)));
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return (ConcurrentMap)((Object)(JdkVersion.getJdkVersion().isUnsafeSupported() ? new ConcurrentHashMapV8(initialCapacity, loadFactor, concurrencyLevel) : new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel)));
    }

    static {
        Class<Object> c;
        String className = null;
        try {
            JdkVersion jdkVersion = JdkVersion.getJdkVersion();
            JdkVersion minimumVersion = JdkVersion.parseVersion("1.7.0");
            className = minimumVersion.compareTo(jdkVersion) <= 0 ? "java.util.concurrent.LinkedTransferQueue" : "org.glassfish.jersey.internal.util.collection.LinkedTransferQueue";
            c = DataStructures.getAndVerify(className);
            Logger.getLogger(DataStructures.class.getName()).log(Level.FINE, "USING LTQ class:{0}", c);
        }
        catch (Throwable t) {
            Logger.getLogger(DataStructures.class.getName()).log(Level.FINE, "failed loading data structure class:" + className + " fallback to embedded one", t);
            c = LinkedBlockingQueue.class;
        }
        LTQ_CLASS = c;
        DEFAULT_CONCURENCY_LEVEL = DataStructures.ceilingNextPowerOfTwo(Runtime.getRuntime().availableProcessors());
    }
}

