/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springframework.boot.autoconfigure;

import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.springframework.boot.autoconfigure.IgniteConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
public class IgniteAutoConfiguration {
    public static final String IGNITE_PROPS_PREFIX = "ignite";

    @ConditionalOnMissingBean
    @Bean
    public IgniteConfigurer nodeConfigurer() {
        return cfg -> {};
    }

    @ConditionalOnMissingBean
    @Bean
    @ConfigurationProperties(prefix="ignite")
    public IgniteConfiguration igniteConfiguration(IgniteConfigurer configurer) {
        IgniteConfiguration cfg = new IgniteConfiguration();
        configurer.accept(cfg);
        return cfg;
    }

    @ConditionalOnBean(value={IgniteConfiguration.class})
    @Bean
    public Ignite igniteInstance(IgniteConfiguration cfg) {
        return Ignition.start((IgniteConfiguration)cfg);
    }
}

