/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.utils.MergingIterator;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.queue.BoundedInMemoryExecutor;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueProducer;
import org.apache.hudi.common.util.queue.IteratorBasedQueueProducer;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BaseMergeHelper;

public class JavaMergeHelper<T extends HoodieRecordPayload>
extends BaseMergeHelper<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    private JavaMergeHelper() {
    }

    public static JavaMergeHelper newInstance() {
        return MergeHelperHolder.JAVA_MERGE_HELPER;
    }

    public void runMerge(HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table, HoodieMergeHandle<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> upsertHandle) throws IOException {
        GenericDatumReader gReader;
        GenericDatumWriter gWriter;
        Schema readSchema;
        boolean externalSchemaTransformation = table.getConfig().shouldUseExternalSchemaTransformation();
        Configuration cfgForHoodieFile = new Configuration(table.getHadoopConf());
        HoodieMergeHandle mergeHandle = upsertHandle;
        HoodieBaseFile baseFile = mergeHandle.baseFileForMerge();
        Configuration hadoopConf = new Configuration(table.getHadoopConf());
        HoodieFileReader baseFileReader = HoodieFileReaderFactory.getFileReader((Configuration)hadoopConf, (Path)mergeHandle.getOldFilePath());
        HoodieFileReader bootstrapFileReader = null;
        if (externalSchemaTransformation || baseFile.getBootstrapBaseFile().isPresent()) {
            readSchema = baseFileReader.getSchema();
            gWriter = new GenericDatumWriter(readSchema);
            gReader = new GenericDatumReader(readSchema, mergeHandle.getWriterSchemaWithMetaFields());
        } else {
            gReader = null;
            gWriter = null;
            readSchema = mergeHandle.getWriterSchemaWithMetaFields();
        }
        BoundedInMemoryExecutor wrapper = null;
        try {
            ClosableIterator readerIterator;
            if (baseFile.getBootstrapBaseFile().isPresent()) {
                Path bootstrapFilePath = new Path(((BaseFile)baseFile.getBootstrapBaseFile().get()).getPath());
                Configuration bootstrapFileConfig = new Configuration(table.getHadoopConf());
                bootstrapFileReader = HoodieFileReaderFactory.getFileReader((Configuration)bootstrapFileConfig, (Path)bootstrapFilePath);
                Schema bootstrapSchema = externalSchemaTransformation ? bootstrapFileReader.getSchema() : mergeHandle.getWriterSchema();
                readerIterator = new MergingIterator((Iterator)baseFileReader.getRecordIterator(readSchema), (Iterator)bootstrapFileReader.getRecordIterator(bootstrapSchema), inputRecordPair -> HoodieAvroUtils.stitchRecords((GenericRecord)((GenericRecord)inputRecordPair.getLeft()), (GenericRecord)((GenericRecord)inputRecordPair.getRight()), (Schema)mergeHandle.getWriterSchemaWithMetaFields()));
            } else {
                readerIterator = baseFileReader.getRecordIterator(readSchema);
            }
            ThreadLocal encoderCache = new ThreadLocal();
            ThreadLocal decoderCache = new ThreadLocal();
            wrapper = new BoundedInMemoryExecutor((long)table.getConfig().getWriteBufferLimitBytes(), (BoundedInMemoryQueueProducer)new IteratorBasedQueueProducer((Iterator)readerIterator), Option.of((Object)new BaseMergeHelper.UpdateHandler(mergeHandle)), record -> {
                if (!externalSchemaTransformation) {
                    return record;
                }
                return this.transformRecordBasedOnNewSchema(gReader, gWriter, encoderCache, decoderCache, (GenericRecord)record);
            });
            wrapper.execute();
        }
        catch (Exception e) {
            throw new HoodieException((Throwable)e);
        }
        finally {
            baseFileReader.close();
            if (bootstrapFileReader != null) {
                bootstrapFileReader.close();
            }
            if (null != wrapper) {
                wrapper.shutdownNow();
                wrapper.awaitTermination();
            }
            mergeHandle.close();
        }
    }

    private static class MergeHelperHolder {
        private static final JavaMergeHelper JAVA_MERGE_HELPER = new JavaMergeHelper();

        private MergeHelperHolder() {
        }
    }
}

