/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieROTablePathFilter
implements Configurable,
PathFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(HoodieROTablePathFilter.class);
    private Map<String, HashSet<Path>> hoodiePathCache = new ConcurrentHashMap<String, HashSet<Path>>();
    Set<String> nonHoodiePathCache = new HashSet<String>();
    Map<String, HoodieTableMetaClient> metaClientCache;
    private SerializableConfiguration conf;
    private transient HoodieLocalEngineContext engineContext;
    private transient FileSystem fs;

    public HoodieROTablePathFilter() {
        this(new Configuration());
    }

    public HoodieROTablePathFilter(Configuration conf) {
        this.conf = new SerializableConfiguration(conf);
        this.metaClientCache = new HashMap<String, HoodieTableMetaClient>();
    }

    private Path safeGetParentsParent(Path path) {
        if (path.getParent() != null && path.getParent().getParent() != null && path.getParent().getParent().getParent() != null) {
            return path.getParent().getParent().getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accept(Path path) {
        if (this.engineContext == null) {
            this.engineContext = new HoodieLocalEngineContext(this.conf.get());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking acceptance for path " + path));
        }
        Path folder = null;
        try {
            Path baseDir;
            if (this.fs == null) {
                this.fs = path.getFileSystem(this.conf.get());
            }
            if (this.nonHoodiePathCache.contains((folder = path.getParent()).toString())) {
                if (!LOG.isDebugEnabled()) return true;
                LOG.debug((Object)("Accepting non-hoodie path from cache: " + path));
                return true;
            }
            if (this.hoodiePathCache.containsKey(folder.toString())) {
                if (!LOG.isDebugEnabled()) return this.hoodiePathCache.get(folder.toString()).contains(path);
                LOG.debug((Object)String.format("%s Hoodie path checked against cache, accept => %s \n", path, this.hoodiePathCache.get(folder.toString()).contains(path)));
                return this.hoodiePathCache.get(folder.toString()).contains(path);
            }
            String filePath = path.toString();
            if (filePath.contains("/.hoodie/") || filePath.endsWith("/.hoodie")) {
                if (!LOG.isDebugEnabled()) return false;
                LOG.debug((Object)String.format("Skipping Hoodie Metadata file  %s \n", filePath));
                return false;
            }
            if (HoodiePartitionMetadata.hasPartitionMetadata((FileSystem)this.fs, (Path)folder)) {
                HoodiePartitionMetadata metadata = new HoodiePartitionMetadata(this.fs, folder);
                metadata.readFromFS();
                baseDir = HoodieHiveUtils.getNthParent(folder, metadata.getPartitionDepth());
            } else {
                baseDir = this.safeGetParentsParent(folder);
            }
            if (baseDir != null) {
                if (this.nonHoodiePathCache.contains(baseDir.toString())) {
                    if (!LOG.isDebugEnabled()) return true;
                    LOG.debug((Object)("Accepting non-hoodie path from cache: " + path));
                    return true;
                }
                try (HoodieTableFileSystemView fsView = null;){
                    HoodieTableMetaClient metaClient = this.metaClientCache.get(baseDir.toString());
                    if (null == metaClient) {
                        metaClient = HoodieTableMetaClient.builder().setConf(this.fs.getConf()).setBasePath(baseDir.toString()).setLoadActiveTimelineOnLoad(true).build();
                        this.metaClientCache.put(baseDir.toString(), metaClient);
                    }
                    fsView = FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)this.engineContext, (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)HoodieInputFormatUtils.buildMetadataConfig(this.getConf()));
                    String partition = FSUtils.getRelativePartitionPath((Path)new Path(metaClient.getBasePath()), (Path)folder);
                    List latestFiles = fsView.getLatestBaseFiles(partition).collect(Collectors.toList());
                    if (!this.hoodiePathCache.containsKey(folder.toString())) {
                        this.hoodiePathCache.put(folder.toString(), new HashSet());
                    }
                    LOG.info((Object)("Based on hoodie metadata from base path: " + baseDir.toString() + ", caching " + latestFiles.size() + " files under " + folder));
                    for (HoodieBaseFile lfile : latestFiles) {
                        this.hoodiePathCache.get(folder.toString()).add(new Path(lfile.getPath()));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("%s checked after cache population, accept => %s \n", path, this.hoodiePathCache.get(folder.toString()).contains(path)));
                    }
                    boolean bl = this.hoodiePathCache.get(folder.toString()).contains(path);
                    return bl;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("(2) Caching non-hoodie path under %s \n", folder.toString()));
            }
            this.nonHoodiePathCache.add(folder.toString());
            return true;
        }
        catch (Exception e) {
            String msg = "Error checking path :" + path + ", under folder: " + folder;
            LOG.error((Object)msg, (Throwable)e);
            throw new HoodieException(msg, (Throwable)e);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = new SerializableConfiguration(conf);
    }

    public Configuration getConf() {
        return this.conf.get();
    }
}

