/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieVirtualKeyInfo;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;

public class RealtimeBootstrapBaseFileSplit
extends BootstrapBaseFileSplit
implements RealtimeSplit {
    private List<String> deltaLogPaths;
    private List<HoodieLogFile> deltaLogFiles = new ArrayList<HoodieLogFile>();
    private String maxInstantTime;
    private String basePath;

    public RealtimeBootstrapBaseFileSplit() {
    }

    public RealtimeBootstrapBaseFileSplit(FileSplit baseSplit, String basePath, List<HoodieLogFile> deltaLogFiles, String maxInstantTime, FileSplit externalFileSplit) throws IOException {
        super(baseSplit, externalFileSplit);
        this.maxInstantTime = maxInstantTime;
        this.deltaLogFiles = deltaLogFiles;
        this.deltaLogPaths = deltaLogFiles.stream().map(entry -> entry.getPath().toString()).collect(Collectors.toList());
        this.basePath = basePath;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.writeToOutput(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.readFromInput(in);
    }

    @Override
    public List<String> getDeltaLogPaths() {
        return this.deltaLogPaths;
    }

    @Override
    public List<HoodieLogFile> getDeltaLogFiles() {
        return this.deltaLogFiles;
    }

    @Override
    public String getMaxCommitTime() {
        return this.maxInstantTime;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public Option<HoodieVirtualKeyInfo> getHoodieVirtualKeyInfo() {
        return Option.empty();
    }

    @Override
    public void setDeltaLogPaths(List<String> deltaLogPaths) {
        this.deltaLogPaths = deltaLogPaths;
    }

    @Override
    public void setMaxCommitTime(String maxInstantTime) {
        this.maxInstantTime = maxInstantTime;
    }

    @Override
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public void setHoodieVirtualKeyInfo(Option<HoodieVirtualKeyInfo> hoodieVirtualKeyInfo) {
    }
}

