/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.realtime.HoodieVirtualKeyInfo;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;

public class HoodieRealtimeFileSplit
extends FileSplit
implements RealtimeSplit {
    private List<String> deltaLogPaths;
    private List<HoodieLogFile> deltaLogFiles = new ArrayList<HoodieLogFile>();
    private String maxCommitTime;
    private String basePath;
    private Option<HoodieVirtualKeyInfo> hoodieVirtualKeyInfo = Option.empty();

    public HoodieRealtimeFileSplit() {
    }

    public HoodieRealtimeFileSplit(FileSplit baseSplit, String basePath, List<HoodieLogFile> deltaLogFiles, String maxCommitTime, Option<HoodieVirtualKeyInfo> hoodieVirtualKeyInfo) throws IOException {
        super(baseSplit.getPath(), baseSplit.getStart(), baseSplit.getLength(), baseSplit.getLocations());
        this.deltaLogFiles = deltaLogFiles;
        this.deltaLogPaths = deltaLogFiles.stream().map(entry -> entry.getPath().toString()).collect(Collectors.toList());
        this.maxCommitTime = maxCommitTime;
        this.basePath = basePath;
        this.hoodieVirtualKeyInfo = hoodieVirtualKeyInfo;
    }

    @Override
    public List<String> getDeltaLogPaths() {
        return this.deltaLogPaths;
    }

    @Override
    public List<HoodieLogFile> getDeltaLogFiles() {
        return this.deltaLogFiles;
    }

    @Override
    public String getMaxCommitTime() {
        return this.maxCommitTime;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setHoodieVirtualKeyInfo(Option<HoodieVirtualKeyInfo> hoodieVirtualKeyInfo) {
        this.hoodieVirtualKeyInfo = hoodieVirtualKeyInfo;
    }

    @Override
    public Option<HoodieVirtualKeyInfo> getHoodieVirtualKeyInfo() {
        return this.hoodieVirtualKeyInfo;
    }

    @Override
    public void setDeltaLogPaths(List<String> deltaLogPaths) {
        this.deltaLogPaths = deltaLogPaths;
    }

    @Override
    public void setMaxCommitTime(String maxCommitTime) {
        this.maxCommitTime = maxCommitTime;
    }

    @Override
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.writeToOutput(out);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.readFromInput(in);
    }

    public String toString() {
        return "HoodieRealtimeFileSplit{DataPath=" + this.getPath() + ", deltaLogPaths=" + this.deltaLogPaths + ", maxCommitTime='" + this.maxCommitTime + '\'' + ", basePath='" + this.basePath + '\'' + '}';
    }
}

