/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.HoodieHFileRecordReader;
import org.apache.hudi.hadoop.InputPathHandler;
import org.apache.hudi.hadoop.UseFileSplitsFromInputFormat;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@UseFileSplitsFromInputFormat
public class HoodieHFileInputFormat
extends FileInputFormat<NullWritable, ArrayWritable>
implements Configurable {
    private static final Logger LOG = LogManager.getLogger(HoodieHFileInputFormat.class);
    protected Configuration conf;

    protected HoodieDefaultTimeline filterInstantsTimeline(HoodieDefaultTimeline timeline) {
        return HoodieInputFormatUtils.filterInstantsTimeline(timeline);
    }

    public FileStatus[] listStatus(JobConf job) throws IOException {
        List<Path> snapshotPaths;
        List<String> incrementalTables = HoodieHiveUtils.getIncrementalTableNames((JobContext)Job.getInstance((Configuration)job));
        InputPathHandler inputPathHandler = new InputPathHandler(this.conf, HoodieHFileInputFormat.getInputPaths((JobConf)job), incrementalTables);
        ArrayList<FileStatus> returns = new ArrayList<FileStatus>();
        Map<String, HoodieTableMetaClient> tableMetaClientMap = inputPathHandler.getTableMetaClientMap();
        for (String table : incrementalTables) {
            List<Path> inputPaths;
            List<FileStatus> result;
            HoodieTableMetaClient metaClient = tableMetaClientMap.get(table);
            if (metaClient == null || (result = this.listStatusForIncrementalMode(job, metaClient, inputPaths = inputPathHandler.getGroupedIncrementalPaths().get(metaClient))) == null) continue;
            returns.addAll(result);
        }
        List<Path> nonHoodiePaths = inputPathHandler.getNonHoodieInputPaths();
        if (nonHoodiePaths.size() > 0) {
            HoodieHFileInputFormat.setInputPaths((JobConf)job, (Path[])nonHoodiePaths.toArray(new Path[nonHoodiePaths.size()]));
            FileStatus[] fileStatuses = super.listStatus(job);
            returns.addAll(Arrays.asList(fileStatuses));
        }
        if ((snapshotPaths = inputPathHandler.getSnapshotPaths()).size() > 0) {
            returns.addAll(HoodieInputFormatUtils.filterFileStatusForSnapshotMode(job, tableMetaClientMap, snapshotPaths));
        }
        return returns.toArray(new FileStatus[0]);
    }

    private List<FileStatus> listStatusForIncrementalMode(JobConf job, HoodieTableMetaClient tableMetaClient, List<Path> inputPaths) throws IOException {
        String tableName = tableMetaClient.getTableConfig().getTableName();
        Job jobContext = Job.getInstance((Configuration)job);
        Option<HoodieTimeline> timeline = HoodieInputFormatUtils.getFilteredCommitsTimeline(jobContext, tableMetaClient);
        if (!timeline.isPresent()) {
            return null;
        }
        Option<List<HoodieInstant>> commitsToCheck = HoodieInputFormatUtils.getCommitsForIncrementalQuery(jobContext, tableName, (HoodieTimeline)timeline.get());
        if (!commitsToCheck.isPresent()) {
            return null;
        }
        Option<String> incrementalInputPaths = HoodieInputFormatUtils.getAffectedPartitions((List)commitsToCheck.get(), tableMetaClient, (HoodieTimeline)timeline.get(), inputPaths);
        if (!incrementalInputPaths.isPresent()) {
            return null;
        }
        HoodieHFileInputFormat.setInputPaths((JobConf)job, (String)((String)incrementalInputPaths.get()));
        FileStatus[] fileStatuses = super.listStatus(job);
        return HoodieInputFormatUtils.filterIncrementalFileStatus(jobContext, tableMetaClient, (HoodieTimeline)timeline.get(), fileStatuses, (List)commitsToCheck.get());
    }

    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new HoodieHFileRecordReader(this.conf, split, job);
    }

    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

