/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub;

import com.beust.jcommander.JCommander;
import java.util.Properties;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncTool;
import org.apache.hudi.sync.datahub.DataHubSyncClient;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;

public class DataHubSyncTool
extends HoodieSyncTool {
    protected final DataHubSyncConfig config;

    public DataHubSyncTool(Properties props) {
        super(props);
        this.config = new DataHubSyncConfig(props);
    }

    public void syncHoodieTable() {
        try (DataHubSyncClient syncClient = new DataHubSyncClient(this.config);){
            syncClient.updateTableSchema(this.config.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME), null);
            syncClient.updateLastCommitTimeSynced(this.config.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME));
        }
    }

    public static void main(String[] args) {
        DataHubSyncConfig.DataHubSyncConfigParams params = new DataHubSyncConfig.DataHubSyncConfigParams();
        JCommander cmd = JCommander.newBuilder().addObject((Object)params).build();
        cmd.parse(args);
        if (params.isHelp()) {
            cmd.usage();
            System.exit(0);
        }
        new DataHubSyncTool(params.toProps()).syncHoodieTable();
    }
}

