/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Arrays;
import java.util.List;

public enum MetadataPartitionType {
    FILES("files", "files-"),
    COLUMN_STATS("column_stats", "col-stats-"),
    BLOOM_FILTERS("bloom_filters", "bloom-filters-");

    private final String partitionPath;
    private final String fileIdPrefix;
    private int fileGroupCount = 1;

    private MetadataPartitionType(String partitionPath, String fileIdPrefix) {
        this.partitionPath = partitionPath;
        this.fileIdPrefix = fileIdPrefix;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public String getFileIdPrefix() {
        return this.fileIdPrefix;
    }

    public void setFileGroupCount(int fileGroupCount) {
        this.fileGroupCount = fileGroupCount;
    }

    public int getFileGroupCount() {
        return this.fileGroupCount;
    }

    public static List<String> allPaths() {
        return Arrays.asList(FILES.getPartitionPath(), COLUMN_STATS.getPartitionPath(), BLOOM_FILTERS.getPartitionPath());
    }

    public String toString() {
        return "Metadata partition {name: " + this.getPartitionPath() + ", prefix: " + this.getFileIdPrefix() + ", groups: " + this.getFileGroupCount() + "}";
    }
}

