/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieMetadataBloomFilter;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.common.util.hash.FileIndexID;
import org.apache.hudi.common.util.hash.PartitionIndexID;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.hadoop.CachingPath;
import org.apache.hudi.hadoop.SerializablePath;
import org.apache.hudi.metadata.FileSystemBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseTableMetadata
implements HoodieTableMetadata {
    private static final Logger LOG = LogManager.getLogger(BaseTableMetadata.class);
    public static final long MAX_MEMORY_SIZE_IN_BYTES = 0x40000000L;
    public static final int BUFFER_SIZE = 0xA00000;
    protected final transient HoodieEngineContext engineContext;
    protected final SerializableConfiguration hadoopConf;
    protected final SerializablePath dataBasePath;
    protected final HoodieTableMetaClient dataMetaClient;
    protected final Option<HoodieMetadataMetrics> metrics;
    protected final HoodieMetadataConfig metadataConfig;
    protected final String spillableMapDirectory;
    protected boolean isMetadataTableEnabled;
    protected boolean isBloomFilterIndexEnabled = false;
    protected boolean isColumnStatsIndexEnabled = false;

    protected BaseTableMetadata(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String dataBasePath, String spillableMapDirectory) {
        this.engineContext = engineContext;
        this.hadoopConf = new SerializableConfiguration(engineContext.getHadoopConf());
        this.dataBasePath = new SerializablePath(new CachingPath(dataBasePath));
        this.dataMetaClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf.get()).setBasePath(dataBasePath).build();
        this.spillableMapDirectory = spillableMapDirectory;
        this.metadataConfig = metadataConfig;
        this.isMetadataTableEnabled = metadataConfig.enabled();
        this.metrics = metadataConfig.enableMetrics() ? Option.of(new HoodieMetadataMetrics(Registry.getRegistry("HoodieMetadata"))) : Option.empty();
    }

    @Override
    public List<String> getAllPartitionPaths() throws IOException {
        if (this.isMetadataTableEnabled) {
            try {
                return this.fetchAllPartitionPaths();
            }
            catch (Exception e) {
                throw new HoodieMetadataException("Failed to retrieve list of partition from metadata", e);
            }
        }
        return new FileSystemBackedTableMetadata(this.getEngineContext(), this.hadoopConf, this.dataBasePath.toString(), this.metadataConfig.shouldAssumeDatePartitioning()).getAllPartitionPaths();
    }

    @Override
    public FileStatus[] getAllFilesInPartition(Path partitionPath) throws IOException {
        if (this.isMetadataTableEnabled) {
            try {
                return this.fetchAllFilesInPartition(partitionPath);
            }
            catch (Exception e) {
                throw new HoodieMetadataException("Failed to retrieve files in partition " + partitionPath + " from metadata", e);
            }
        }
        return new FileSystemBackedTableMetadata(this.getEngineContext(), this.hadoopConf, this.dataBasePath.toString(), this.metadataConfig.shouldAssumeDatePartitioning()).getAllFilesInPartition(partitionPath);
    }

    @Override
    public Map<String, FileStatus[]> getAllFilesInPartitions(List<String> partitions) throws IOException {
        if (partitions.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.isMetadataTableEnabled) {
            try {
                List<Path> partitionPaths = partitions.stream().map(Path::new).collect(Collectors.toList());
                return this.fetchAllFilesInPartitionPaths(partitionPaths);
            }
            catch (Exception e) {
                throw new HoodieMetadataException("Failed to retrieve files in partition from metadata", e);
            }
        }
        return new FileSystemBackedTableMetadata(this.getEngineContext(), this.hadoopConf, this.dataBasePath.toString(), this.metadataConfig.shouldAssumeDatePartitioning()).getAllFilesInPartitions(partitions);
    }

    @Override
    public Option<BloomFilter> getBloomFilter(String partitionName, String fileName) throws HoodieMetadataException {
        if (!this.isBloomFilterIndexEnabled) {
            LOG.error((Object)"Metadata bloom filter index is disabled!");
            return Option.empty();
        }
        Pair<String, String> partitionFileName = Pair.of(partitionName, fileName);
        Map<Pair<String, String>, BloomFilter> bloomFilters = this.getBloomFilters(Collections.singletonList(partitionFileName));
        if (bloomFilters.isEmpty()) {
            LOG.error((Object)("Meta index: missing bloom filter for partition: " + partitionName + ", file: " + fileName));
            return Option.empty();
        }
        ValidationUtils.checkState(bloomFilters.containsKey(partitionFileName));
        return Option.of(bloomFilters.get(partitionFileName));
    }

    @Override
    public Map<Pair<String, String>, BloomFilter> getBloomFilters(List<Pair<String, String>> partitionNameFileNameList) throws HoodieMetadataException {
        if (!this.isBloomFilterIndexEnabled) {
            LOG.error((Object)"Metadata bloom filter index is disabled!");
            return Collections.emptyMap();
        }
        if (partitionNameFileNameList.isEmpty()) {
            return Collections.emptyMap();
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        TreeSet partitionIDFileIDSortedStrings = new TreeSet();
        HashMap fileToKeyMap = new HashMap();
        partitionNameFileNameList.forEach(partitionNameFileNamePair -> {
            String bloomFilterIndexKey = HoodieMetadataPayload.getBloomFilterIndexKey(new PartitionIndexID((String)partitionNameFileNamePair.getLeft()), new FileIndexID((String)partitionNameFileNamePair.getRight()));
            partitionIDFileIDSortedStrings.add(bloomFilterIndexKey);
            fileToKeyMap.put(bloomFilterIndexKey, partitionNameFileNamePair);
        });
        ArrayList<String> partitionIDFileIDStrings = new ArrayList<String>(partitionIDFileIDSortedStrings);
        List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> hoodieRecordList = this.getRecordsByKeys(partitionIDFileIDStrings, MetadataPartitionType.BLOOM_FILTERS.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_meta_index_bloom_filters", timer.endTimer() / (long)partitionIDFileIDStrings.size()));
        HashMap<Pair<String, String>, BloomFilter> partitionFileToBloomFilterMap = new HashMap<Pair<String, String>, BloomFilter>();
        for (Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>> entry : hoodieRecordList) {
            if (!entry.getRight().isPresent()) continue;
            Option<HoodieMetadataBloomFilter> bloomFilterMetadata = entry.getRight().get().getData().getBloomFilterMetadata();
            if (bloomFilterMetadata.isPresent()) {
                if (bloomFilterMetadata.get().getIsDeleted().booleanValue()) continue;
                ValidationUtils.checkState(fileToKeyMap.containsKey(entry.getLeft()));
                ByteBuffer bloomFilterByteBuffer = bloomFilterMetadata.get().getBloomFilter();
                String bloomFilterType = bloomFilterMetadata.get().getType();
                BloomFilter bloomFilter = BloomFilterFactory.fromString(StandardCharsets.UTF_8.decode(bloomFilterByteBuffer).toString(), bloomFilterType);
                partitionFileToBloomFilterMap.put((Pair<String, String>)fileToKeyMap.get(entry.getLeft()), bloomFilter);
                continue;
            }
            LOG.error((Object)("Meta index bloom filter missing for: " + fileToKeyMap.get(entry.getLeft())));
        }
        return partitionFileToBloomFilterMap;
    }

    @Override
    public Map<Pair<String, String>, HoodieMetadataColumnStats> getColumnStats(List<Pair<String, String>> partitionNameFileNameList, String columnName) throws HoodieMetadataException {
        if (!this.isColumnStatsIndexEnabled) {
            LOG.error((Object)"Metadata column stats index is disabled!");
            return Collections.emptyMap();
        }
        HashMap<String, Pair<String, String>> columnStatKeyToFileNameMap = new HashMap<String, Pair<String, String>>();
        TreeSet<String> sortedKeys = new TreeSet<String>();
        ColumnIndexID columnIndexID = new ColumnIndexID(columnName);
        for (Pair<String, String> partitionNameFileNamePair : partitionNameFileNameList) {
            String columnStatsIndexKey = HoodieMetadataPayload.getColumnStatsIndexKey(new PartitionIndexID(partitionNameFileNamePair.getLeft()), new FileIndexID(partitionNameFileNamePair.getRight()), columnIndexID);
            sortedKeys.add(columnStatsIndexKey);
            columnStatKeyToFileNameMap.put(columnStatsIndexKey, partitionNameFileNamePair);
        }
        ArrayList<String> columnStatKeys = new ArrayList<String>(sortedKeys);
        HoodieTimer timer = new HoodieTimer().startTimer();
        List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> hoodieRecordList = this.getRecordsByKeys(columnStatKeys, MetadataPartitionType.COLUMN_STATS.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_meta_index_column_ranges", timer.endTimer()));
        HashMap<Pair<String, String>, HoodieMetadataColumnStats> fileToColumnStatMap = new HashMap<Pair<String, String>, HoodieMetadataColumnStats>();
        for (Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>> entry : hoodieRecordList) {
            if (!entry.getRight().isPresent()) continue;
            Option<HoodieMetadataColumnStats> columnStatMetadata = entry.getRight().get().getData().getColumnStatMetadata();
            if (columnStatMetadata.isPresent()) {
                if (columnStatMetadata.get().getIsDeleted().booleanValue()) continue;
                ValidationUtils.checkState(columnStatKeyToFileNameMap.containsKey(entry.getLeft()));
                Pair partitionFileNamePair = (Pair)columnStatKeyToFileNameMap.get(entry.getLeft());
                ValidationUtils.checkState(!fileToColumnStatMap.containsKey(partitionFileNamePair));
                fileToColumnStatMap.put(partitionFileNamePair, columnStatMetadata.get());
                continue;
            }
            LOG.error((Object)("Meta index column stats missing for: " + entry.getLeft()));
        }
        return fileToColumnStatMap;
    }

    protected List<String> fetchAllPartitionPaths() {
        HoodieTimer timer = new HoodieTimer().startTimer();
        Option<HoodieRecord<HoodieMetadataPayload>> recordOpt = this.getRecordByKey("__all_partitions__", MetadataPartitionType.FILES.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_partitions", timer.endTimer()));
        List<String> partitions = recordOpt.map(record -> {
            HoodieMetadataPayload metadataPayload = (HoodieMetadataPayload)record.getData();
            this.checkForSpuriousDeletes(metadataPayload, "\"all partitions\"");
            List<String> relativePaths = metadataPayload.getFilenames();
            if (relativePaths.size() == 1 && relativePaths.get(0).equals(".")) {
                return Collections.singletonList("");
            }
            return relativePaths;
        }).orElse(Collections.emptyList());
        LOG.info((Object)("Listed partitions from metadata: #partitions=" + partitions.size()));
        return partitions;
    }

    FileStatus[] fetchAllFilesInPartition(Path partitionPath) throws IOException {
        String relativePartitionPath = FSUtils.getRelativePartitionPath(this.dataBasePath.get(), partitionPath);
        String recordKey = relativePartitionPath.isEmpty() ? "." : relativePartitionPath;
        HoodieTimer timer = new HoodieTimer().startTimer();
        Option<HoodieRecord<HoodieMetadataPayload>> recordOpt = this.getRecordByKey(recordKey, MetadataPartitionType.FILES.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_files", timer.endTimer()));
        FileStatus[] statuses = recordOpt.map(record -> {
            HoodieMetadataPayload metadataPayload = (HoodieMetadataPayload)record.getData();
            this.checkForSpuriousDeletes(metadataPayload, recordKey);
            try {
                return metadataPayload.getFileStatuses(this.hadoopConf.get(), partitionPath);
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to extract file-statuses from the payload", e);
            }
        }).orElse(new FileStatus[0]);
        LOG.info((Object)("Listed file in partition from metadata: partition=" + relativePartitionPath + ", #files=" + statuses.length));
        return statuses;
    }

    Map<String, FileStatus[]> fetchAllFilesInPartitionPaths(List<Path> partitionPaths) throws IOException {
        Map partitionIdToPathMap = partitionPaths.parallelStream().collect(Collectors.toMap(partitionPath -> {
            String partitionId = FSUtils.getRelativePartitionPath(this.dataBasePath.get(), partitionPath);
            return partitionId.isEmpty() ? "." : partitionId;
        }, Function.identity()));
        HoodieTimer timer = new HoodieTimer().startTimer();
        List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> partitionIdRecordPairs = this.getRecordsByKeys(new ArrayList<String>(partitionIdToPathMap.keySet()), MetadataPartitionType.FILES.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_files", timer.endTimer()));
        FileSystem fs = partitionPaths.get(0).getFileSystem(this.hadoopConf.get());
        Map<String, FileStatus[]> partitionPathToFilesMap = partitionIdRecordPairs.parallelStream().map(pair -> {
            String partitionId = (String)pair.getKey();
            Option recordOpt = (Option)pair.getValue();
            Path partitionPath = (Path)partitionIdToPathMap.get(partitionId);
            return recordOpt.map(record -> {
                HoodieMetadataPayload metadataPayload = (HoodieMetadataPayload)record.getData();
                this.checkForSpuriousDeletes(metadataPayload, partitionId);
                FileStatus[] files = metadataPayload.getFileStatuses(fs, partitionPath);
                return Pair.of(partitionPath.toString(), files);
            }).orElse(null);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        LOG.info((Object)("Listed files in partitions from metadata: partition list =" + Arrays.toString(partitionPaths.toArray())));
        return partitionPathToFilesMap;
    }

    private void checkForSpuriousDeletes(HoodieMetadataPayload metadataPayload, String partitionName) {
        if (!metadataPayload.getDeletions().isEmpty()) {
            if (this.metadataConfig.ignoreSpuriousDeletes()) {
                LOG.warn((Object)("Metadata record for " + partitionName + " encountered some files to be deleted which was not added before. Ignoring the spurious deletes as the `" + HoodieMetadataConfig.IGNORE_SPURIOUS_DELETES.key() + "` config is set to true"));
            } else {
                throw new HoodieMetadataException("Metadata record for " + partitionName + " is inconsistent: " + metadataPayload);
            }
        }
    }

    protected abstract Option<HoodieRecord<HoodieMetadataPayload>> getRecordByKey(String var1, String var2);

    public abstract List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> getRecordsByKeys(List<String> var1, String var2);

    protected HoodieEngineContext getEngineContext() {
        return this.engineContext != null ? this.engineContext : new HoodieLocalEngineContext(this.hadoopConf.get());
    }

    public HoodieMetadataConfig getMetadataConfig() {
        return this.metadataConfig;
    }

    protected String getLatestDataInstantTime() {
        return this.dataMetaClient.getActiveTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::getTimestamp).orElse("00000000000000");
    }
}

